﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Xml.Linq;
using ScrollingSample.Data;
using System.Web.Http;

namespace ScrollingSample.Controllers
{
    public class ProductController : ApiController
    {
        NorthWindDataContext _context = new NorthWindDataContext();

        /// <summary>
        /// Gets the specified page size.
        /// </summary>
        /// <param name="pageSize">Size of the page.</param>
        /// <param name="currentPage">The current page.</param>
        /// <param name="mode">The mode.</param>
        /// <returns></returns>
        public List<Model.Product> Get()
        {
            List<Model.Product> products = new List<Model.Product>();

         
                products = (from e in _context.Products
                             select new Model.Product
                             {
                                 ProductID = e.ProductID,
                                 ProductName = e.ProductName,
                                 SupplierName = e.Supplier.CompanyName,
                                 CategoryName = e.Category.CategoryName,
                                 UnitPrice = Convert.ToDecimal(e.UnitPrice)
                             }).ToList();
            
            return products;
        }

        /// <summary>
        /// Gets the specified page size.
        /// </summary>
        /// <param name="pageSize">Size of the page.</param>
        /// <param name="currentPage">The current page.</param>
        /// <param name="mode">The mode.</param>
        /// <returns></returns>
        public List<Model.Product> GetProductsByPage(int pageSize, int currentPage, string mode)
        {
            List<Model.Product> products = new List<Model.Product>();

            if (string.Equals("XML", mode, StringComparison.OrdinalIgnoreCase)) //if XML
            {
                string xmlPath = HttpContext.Current.Server.MapPath(@"/Data/Product.xml");
                XElement xml = XElement.Load(xmlPath);

                products = xml.Descendants("Product")
                    .Select(e => new Model.Product
                    {
                        ProductID = Convert.ToInt32(e.Descendants("ProductID").FirstOrDefault().Value),
                        ProductName = e.Descendants("ProductName").FirstOrDefault().Value,
                        SupplierName = e.Descendants("SupplierName").FirstOrDefault().Value,
                        CategoryName = e.Descendants("CategoryName").FirstOrDefault().Value,
                        UnitPrice = Convert.ToDecimal(e.Descendants("UnitPrice").FirstOrDefault().Value)
                    }).Skip(pageSize * currentPage).Take(pageSize).ToList();

            }
            else //if SQL
            {
                products = (from e in _context.Products
                             select new Model.Product
                             {
                                 ProductID = e.ProductID,
                                 ProductName = e.ProductName,
                                 SupplierName = e.Supplier.CompanyName,
                                 CategoryName = e.Category.CategoryName,
                                 UnitPrice = Convert.ToDecimal(e.UnitPrice)
                             }).Skip(pageSize * currentPage).Take(pageSize).ToList();
            }
            return products;
        }
    }
}