﻿using System;
using System.Collections.Generic;
using System.Data.SqlClient;
using System.Linq;
using System.Web;

namespace HowToSecurePasswordInDatabaseArticle
{
    public class UserDatabase
    {
        private static string connectionstring = "***";

        public static bool AddUser(string username, string password)
        {
            // This function will add a user to our database

            // First create a new Guid fior the user
            Guid userGuid = System.Guid.NewGuid();

            string hashedPassword = Security.HashSHA1(password + userGuid.ToString());

            SqlConnection con = new SqlConnection(connectionstring);
            using (SqlCommand cmd = new SqlCommand("INSERT INTO [Users] VALUES (@username, @password, @userguid)", con))
            {
                cmd.Parameters.AddWithValue("@username", username);
                cmd.Parameters.AddWithValue("@password", hashedPassword);
                cmd.Parameters.AddWithValue("@userguid", userGuid);

                con.Open();
                cmd.ExecuteNonQuery();
                con.Close();
            }
            return true;
        }

        public static int GetUserIdByUsernameAndPassword(string username, string password)
        {
            // this is the value we will return
            int userId = 0;

            SqlConnection con = new SqlConnection(connectionstring);
            using (
                SqlCommand cmd =
                    new SqlCommand("SELECT UserId, Password, UserGuid FROM [Users] WHERE username=@username", con))
            {
                cmd.Parameters.AddWithValue("@username", username);
                con.Open();
                SqlDataReader dr = cmd.ExecuteReader();
                while (dr.Read())
                {
                    // read data from database if we found any user
                    int dbUserId = Convert.ToInt32(dr["UserId"]);
                    string dbPassword = Convert.ToString(dr["Password"]);
                    string dbUserGuid = Convert.ToString(dr["UserGuid"]);

                    // Now we hash the UserGuid from the database with the password we wan't to check
                    // In the same way as when we saved it to the database in the first place.
                    string hashedPassword = Security.HashSHA1(password + dbUserGuid);

                    // if its correct password the result of the hash is the same as in the database
                    if (dbPassword == hashedPassword)
                    {
                        // The password is correct
                        userId = dbUserId;
                    }
                }
                con.Close();
            }

            // Return the user id which is 0 if we did not found a user.
            return userId;
        }
    }
}