﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using App.Utilities.Web.Handlers;

namespace CodeProject.HandlerFormAction
{
	public class ActionHandler : BaseHandler
	{

		public override void OnMethodInvoke(OnMethodInvokeArgs e)
		{
			context.Response.Cache.SetCacheability(HttpCacheability.ServerAndNoCache);
			context.Response.Cache.SetExpires(DateTime.MinValue);
			context.Response.Cache.SetNoStore();

			//e.Cancel = true;

			SetResponseContentType(ResponseContentTypes.HTML);
		}

		public override void AfterMethodInvoke(object result)
		{
			base.AfterMethodInvoke(result);
		}

		public string DoSomething() 
		{
			return "Done!";
		}
	}
}