<?php

/* **************************************************************** *

Author    : Mustafa Berkan BICER
MSN       : mberkanbicer@hotmail.com
Blog      : www.mberkan.info

Details   : This class generates pages from template file.

Function Structures :

Function loadTemplateFile($template = "/templates/default/html_templates/index.html")
	$template       : This function will load this file. So, this parameter must be identified.

Function parse($file)
	$file           : This function returns parsed file content.

Function putTemplateValues($tags = array())
	$tags           : This function will replace tags in template file.
	
Function showPage()
	no parameter    : This function returns finished template data.
	
** **************************************************************** */

class makeTemplate{
	
	var $page="";
	
	function loadTemplateFile($template = "/templates/default/html_templates/index.html"){
		if (file_exists($template)){
			$this->page = join("", file($template));
		}else{
			die("Sablon dosyasi bulunamadi.");
		}
	}
	
	function parse($file){
	  ob_start();
	  include($file);
	  $buffer = ob_get_contents();
	  ob_end_clean();
	  return $buffer;
	}	
	
	function putTemplateValues($tags = array()){
		if (sizeof($tags) > 0){
			foreach ($tags as $tag => $data){
				$data = (file_exists($data)) ? $this->parse($data) : $data;
				$this->page = eregi_replace("{!" . $tag . "}", $data, $this->page);
			}
		}else{
			die("Parametre eksik!");
		}
	}
	
	function showPage(){
		echo $this->page;
	}
}