<?php
/**
 * @author Dick Munroe <munroe@csworks.com>
 * @copyright copyright @ Dick Munroe, 2007 All rights reserved.
 * @license http://www.csworks.com/publications/ModifiedNetBSD.html
 * @version 1.0.0
 * @package File
 *
 *	$Author: dickmunroe $
 *	$Date: 2007/11/30 10:32:45 $
 *
 * Edit History:
 *
 *  Dick Munroe (munroe@csworks.com) 30-Nov-2007
 *      Initial Version Created
 */

/**
 * Parse a tab or comma delimited data line.  Examples of such file are produced by Excel
 * and Paypal when requesting log files.
 *
 * @package DelimitedTextFiles
 */

class DelimitedTextFiles
{
    var $mDelimiter ;
    var $mItem ;

    /**
     * @desc Constructor
     * @param string [optional] a line of the file to be parsed.
     * @param string [optional] the delimiter for the fields.
     * @return reference to object
     */

    function DelimitedTextFiles(
        $theItem = NULL,
        $theDelimiter = "\t")
    {
        $this->mDelimiter = $theDelimiter ;

        if ($theItem !== NULL)
        {
            $this->mItem = &$this->parse($theItem) ;
        }
    }

    function &getItem()
    {
        return $this->mItem ;
    }

    /**
     * @desc parse a line of delimited text.  This can be called as a static member function.
     * The individual fields may be enclosed in double quotes as well.
     *
     * @param string a line of the file to be parsed.
     * @param string the delimiter for the fields.
     * @return array of parsed fields.
     */

    function &parse(
        $theItem,
        $theDelimiter = NULL)
    {
        $theItem = chop($theItem) ;

        $return = array() ;

        if ($theDelimiter === NULL)
        {
            $theDelimiter = $this->mDelimiter ;
        }

        $endOfLine = chr(13) . chr(10) ;

        $length = strlen($theItem) ;

        $quoteFlag = FALSE ;
        $inField = FALSE ;
        $result = "" ;

        for ($i = 0; $i < $length; $i++)
        {
            if (strpos($endOfLine, $theItem{$i}))
            {
                break ;
            }

            if ($theItem{$i} == '"')
            {
                if ($quoteFlag)
                {
                    if (substr($theItem, $i, 2) == '""')
                    {
                        $result .= '"' ;
                        $i++ ;
                    }
                    else
                    {
                        $quoteFlag = FALSE ;
                    }
                }
                else
                {
                    $quoteFlag = TRUE ;
                    $inField = TRUE ;
                }
            }
            else
            {
                if ($theDelimiter != $theItem{$i})
                {
                    if ($inField)
                    {
                        $result .= $theItem{$i} ;
                    }
                    else
                    {
                        if (strpos("\t ", $theItem{$i}) === FALSE)
                        {
                            $inField = TRUE ;
                            $result .= $theItem{$i} ;
                        }
                    }
                }
                else
                {
                    $return[] = $result ;
                    $result = "" ;
                    $inField = FALSE ;
                }
            }
        }

        if ($result != "")
        {
            $return[] = $result ;
            $result = "" ;
        }

        return $return ;
    }
}
?>
