<?php
/**
 * @category	Modules
 * @package		Instagram Geo Gallery Module
 * @copyright (C) 2012 Nordmograph.com
 * @license		GNU/GPL, see LICENSE.php
 */
defined('_JEXEC') or die('Restricted access');
class mod_instagram_geogalHelper {
	function getEntryData( $params ){
		$juri = JURI::base();
		$client_id				= $params->get('client_id');
		$mode					= $params->get('mode',2);
		$count 					= $params->get('count','32');
		$primary_tag			= $params->get('primary_tag','nordmograph');
		$secondary_tag			= $params->get('secondary_tag','joomla');
		$only_localized			= $params->get('only_localized',0);
		$show_map 				= $params->get('show_map',1); 
		$show_gallery 			= $params->get('show_gallery',1); 
		if($mode==1)
			$api1 = 'https://api.instagram.com/v1/media/popular?client_id='.$client_id;
		elseif($mode==2)
			$api1 = 'https://api.instagram.com/v1/tags/'.$primary_tag.'/media/recent?client_id='.$client_id;
		$api1 .= '&count='.($count +1);
		$response1 = file_get_contents($api1);
		$images = array();
		$i = 0;	
		foreach(json_decode($response1)->data as $item){
			$i++;
			$title = '';
			$latitude =''; 	
			$longitude =''; 				
			$thumb = '';
			$link = '';
			$created_time = '';
			$nick = '';
			$avatar = '';
			$likes ='';
			$comments='';				
			if($item->caption){
				$image_title = $item->caption->text;
				$title = mb_substr($image_title,0,70,"utf8");
			}				
			$src = $item->images->standard_resolution->url;
			if($show_map && $item->location){
				$latitude = $item->location->latitude;
				$longitude = $item->location->longitude;				
			}				
			if($show_gallery OR $show_map){
				$thumb = $item->images->thumbnail->url;
				$link = $item->link;
				$created_time = $item->created_time;
				$nick = $item->user->username;
				$avatar = $item->user->profile_picture;
				$likes = $item->likes->count;
				$comments = $item->comments->count;
			}
			if ( ($only_localized && $latitude!='') OR !$only_localized){
				$images[] = array(
						"title" => htmlspecialchars($title),
						"src" => htmlspecialchars($src),
						"latitude" => htmlspecialchars($latitude),
						"longitude" => htmlspecialchars($longitude),
						"thumb" => htmlspecialchars($thumb),
						"username" => htmlspecialchars($nick),
						"link" => htmlspecialchars($link),
						"created_time" => htmlspecialchars($created_time),
						"profile_picture" => htmlspecialchars($avatar),
						"likes" => $likes,
						"comments" => $comments,
				);	
			}
		}
		
		if($mode==2 && $secondary_tag && $i < $count){
			$api2 = 'https://api.instagram.com/v1/tags/'.$secondary_tag.'/media/recent?client_id='.$client_id.'&count='.($count - $i +1);
			$response2 = file_get_contents($api2);
			foreach(json_decode($response2)->data as $item){			
				$title = '';
				$latitude =''; 	
				$longitude =''; 	
				$thumb = '';
				$link = '';
				$created_time = '';
				$nick = '';
				$avatar = '';
				if($item->caption){
						$title = mb_substr($item->caption->text,0,70,"utf8");
				}
				$src = $item->images->standard_resolution->url;
				if($show_map && $item->location){
					$latitude = $item->location->latitude;
					$longitude = $item->location->longitude;
				}
				if($show_gallery OR $show_map){
					$thumb = $item->images->thumbnail->url;
					$link = $item->link;
					$created_time = $item->created_time;
					$nick = $item->user->username;
					$avatar = $item->user->profile_picture;
					$likes = $item->likes->count;
					$comments = $item->comments->count;
				}		
				if ( ($only_localized && $latitude!='') OR !$only_localized){
					$images[] = array(
						"title" => htmlspecialchars($title),
						"src" => htmlspecialchars($src),
						"latitude" => htmlspecialchars($latitude),
						"longitude" => htmlspecialchars($longitude),
						"thumb" => htmlspecialchars($thumb),
						"username" => htmlspecialchars($nick),
						"link" => htmlspecialchars($link),
						"created_time" => htmlspecialchars($created_time),
						"profile_picture" => htmlspecialchars($avatar),
						"likes" => $likes,
						"comments" => $comments,
					);	
				}		
			}
		}
		return $images;	
	}
}