<?php

/**
 * @package     Extly.Plugins
 * @subpackage  JFontAwesome - Font Awesome for Joomla
 * 
 * @author      Prieco S.A. <support@extly.com>
 * @copyright   Copyright (C) 2007 - 2012 Prieco, S.A. All rights reserved.
 * @license     http://http://www.gnu.org/licenses/gpl-3.0.html GNU/GPL 
 * @link        http://www.extly.com http://support.extly.com http://www.prieco.com
 */
// No direct access
defined('_JEXEC') or die('Restricted index access');

jimport('joomla.plugin.plugin');

/**
 * SobiPro Search plugin
 *
 * @package		Extly.Plugins
 * @subpackage          System.jfontawesome
 * @since		1.0
 */
class plgSystemJFontAwesome extends JPlugin {

    /**
     * Constructor
     *
     * @access      protected
     * @param       object  $subject The object to observe
     * @param       array   $config  An array that holds the plugin configuration
     * @since       1.0
     */
    public function __construct(& $subject, $config) {
        parent::__construct($subject, $config);
    }

    function onAfterRoute() {
        $document = &JFactory::getDocument();

        if (!$this->params->get('activateatbackend')) {
            $juri = &JFactory::getURI();
            if (strpos($juri->getPath(), '/administrator/') !== false)
                return;
        }

        if ($value = $this->params->get('embedjfontawe')) {
            
            $minimified = $this->params->get('minimified');
                    
            if ($value == 1)
            {
                if ($minimified)
                {
                    $document->addStyleSheet(JURI::root(true) . "/plugins/system/jfontawesome/css/font-awesome.min.css");
                }
                else
                {
                    $document->addStyleSheet(JURI::root(true) . "/plugins/system/jfontawesome/css/font-awesome.css");
                }
            }
            elseif ($value == 2)
            {
                $document->addStyleSheet($this->params->get('jfontawecdnpath'));
            }
        }
    }

}