<?php
/**
 * Test for example3.php
 * @author Rubens Takiguti Ribeiro <rubs33@gmail.com>
 */

// Configure this variable with base url for example3.php
$url = 'http://localhost/expires/';

do_test($url);


/**
 * Execute test
 * @return void
 */
function do_test($url) {
    // Request #1
    fwrite(STDOUT, "Request #1 with value 'a'\n");
    $context = stream_context_create(
        array(
            'http' => array(
                'method' => 'GET',
                'header' => ''
            )
        )
    );
    $http_response_content = file_get_contents($url . 'example3.php?value=a', null, $context);
    if (!$http_response_content) {
        fwrite(STDERR, "Error on response #1: unknown error\n");
        exit(1);
    }

    // Check header
    list($response_code, $header) = parse_header($http_response_header);
    fwrite(STDOUT, "Response code: {$response_code} / Expected: 200\n");
    if ($response_code !== 200) {
        fwrite(STDERR, "Error on response #1: invalid response code ({$response_code})\n");
        exit(1);
    }

    // Get cookie, date, cache-control, expires, last-modified
    $cookies = array();
    if (isset($header['set-cookie'])) {
        $cookies = parse_cookies($header['set-cookie']);
    }
    if (!isset($header['date'])) {
        fwrite(STDERR, "Error on response #1: date not received\n");
        exit(1);
    }
    if (!isset($header['cache-control'])) {
        fwrite(STDERR, "Error on response #1: cache-control not received\n");
        exit(1);
    }
    if (!isset($header['expires'])) {
        fwrite(STDERR, "Error on response #1: expires not received\n");
        exit(1);
    }
    if (!isset($header['last-modified'])) {
        fwrite(STDERR, "Error on response #1: last-modified not received\n");
        exit(1);
    }

    $if_modified_since = current($header['last-modified']);

    $cookie_str = '';
    $separator = '';
    foreach ($cookies as $cookie => $value) {
        $cookie_str .= sprintf('%s%s=%s', $separator, $cookie, urlencode($value));
        $separator = '; ';
    }

    $header_str = '';
    $header_str .= "If-Modified-Since: {$if_modified_since}\r\n";
    $header_str .= "Cookie: {$cookie_str}\r\n";

    // Request #2
    fwrite(STDOUT, "Request #2 with value 'b'\n");
    $context = stream_context_create(
        array(
            'http' => array(
                'method' => 'GET',
                'header' => $header_str
            )
        )
    );
    $http_response_content = file_get_contents($url . 'example3.php?value=b', null, $context);

    // Check header
    list($response_code, $header) = parse_header($http_response_header);
    fwrite(STDOUT, "Response code: {$response_code} / Expected: 304\n");
    if ($response_code !== 304) {
        fwrite(STDERR, "Error on response #2: invalid response code ({$response_code})\n");
        exit(1);
    }

    fwrite(STDOUT, "Sleep for 11 seconds to expire cache\n");
    sleep(11);

    // Request #3
    fwrite(STDOUT, "Request #3 with value 'a'\n");
    $context = stream_context_create(
        array(
            'http' => array(
                'method' => 'GET',
                'header' => $header_str
            )
        )
    );
    $http_response_content = file_get_contents($url . 'example3.php?value=a', null, $context);

    // Check header
    list($response_code, $header) = parse_header($http_response_header);
    fwrite(STDOUT, "Response code: {$response_code} / Expected: 200\n");
    if ($response_code !== 200) {
        fwrite(STDERR, "Error on response #3: invalid response code ({$response_code})\n");
        exit(1);
    }

    fwrite(STDOUT, "Test passed\n");
    exit(0);
}

/**
 * Parse header
 * @return array[int, array[string => string]]
 */
function parse_header($header) {
    $response_code = null;
    $parsed_header = array();
    foreach ($header as $line) {
        if (preg_match('/^HTTP\/\d+\.\d+\s([1-5]\d\d)\s/i', $line, $matches)) {
            $response_code = (int)$matches[1];
        } elseif (preg_match('/^\s*([^:]+)\s*:\s*(.*?)\s*$/', $line, $matches)) {
            $key = strtolower($matches[1]);
            if (!isset($parsed_header[$key])) {
                $parsed_header[$key] = array();
            }
            $parsed_header[$key][] = $matches[2];
        }
    }
    return array($response_code, $parsed_header);
}

/**
 * Parse cookies
 * @param array[string] $cookies
 * @return array[string => string]
 */
function parse_cookies($cookies) {
    $parsed_cookies = array();
    foreach ($cookies as $value) {
        if (preg_match('/^([^=]+)=([^;]+)(;.*)?/', $value, $matches)) {
            $parsed_cookies[$matches[1]] = urldecode($matches[2]);
        }
    }
    return $parsed_cookies;
}