<?php 
	// your connect variables to your sql server
	include_once ('../includes/serverstring.php'); // change this part to suit your connection
	/*	the SQL to create the table		
		CREATE TABLE `clicktale` (
		  `PK_ID` int(10) unsigned NOT NULL AUTO_INCREMENT,
		  `CoordX` int(10) unsigned NOT NULL,
		  `CoordY` int(10) unsigned NOT NULL,
		  `IP` varchar(45) NOT NULL,
		  `Session` varchar(45) NOT NULL,
		  `CreateDate` datetime NOT NULL,
		  `URL` varchar(45) NOT NULL,
		  PRIMARY KEY (`PK_ID`)
		) ENGINE=InnoDB AUTO_INCREMENT=65 DEFAULT CHARSET=utf8;	
	*/
	class clicktale {
		public $width = 342;
		public $height = 600;
		public $reduction = 4;
		public $selector = 0;
	
		public function __construct(){
			if(!isset($_SESSION['clicktale'])){
				//if you dont have a user session, we just make a hash number
				$_SESSION['clicktale'] = md5($_SERVER['REMOTE_ADDR'].time());	
			}			
			if(isset($_REQUEST['width'])){
				$this->width = $_REQUEST['width'];
			}
			if(isset($_REQUEST['height'])){
				$this->height = $_REQUEST['height'];
			}
			if(isset($_REQUEST['reduction'])){
				$this->reduction = $_REQUEST['reduction'];
				// just in case
				if($this->reduction <= 1){
					$this->reduction = 1;
				}				
			}	
			if(isset($_REQUEST['selector'])){
				$this->selector = $_REQUEST['selector'];
			}			
		}
	
		public function logClick($CoordX,$CoordY,$URL){
			//change this bit to your own user session.
			//$loginname is the variable that is saved.
			if(isset($_SESSION['customerid'])){
				list($customerid,$loginname) = $_SESSION['customerid'];
			} else {
				$loginname = $_SESSION['clicktale'];
			}
			$sql = "INSERT INTO clicktale (CoordX,CoordY,IP,Session,CreateDate,URL) ";			
			$sql .= " VALUES (".$CoordX.",".$CoordY.",'".$_SERVER['REMOTE_ADDR']."','".$loginname."',NOW(),'".$URL."')";
			try{
				if(!mysql_query($sql)){
					throw new Exception('Could not create new clicktale entry');
				}
			}
			catch (Exception $e){
				echo 'Caught exception: ',  $e->getMessage(), "<br />";
			}				
		}
		
		// selector is used to select between different clauses.
		// 1) selects on id
		// 2) selects on url
		// 3) selects on date
		// 0) or +3) selects all
		public function createImage($selector,$clause){			
			$image = ImageCreate($this->width, $this->height);
			$border = ImageColorAllocate($image, 100, 100, 100);
			$bgcolor = ImageColorAllocate($image, 255, 255, 255);
			ImageFill($image, 0, 0, $bgcolor);			
			imagerectangle ($image,0,0,$this->width-1,$this->height-1,$border);
			
			$sql = "SELECT CoordX, CoordY FROM clicktale";
			switch($selector){
				case 1:
					$sql .= " WHERE Session = '".$clause."'";
					break;
				case 2:	
					$sql .= " WHERE URL ='".$clause."'";
					break;
				case 3:
					$sql .= " WHERE CreateDate LIKE '".$clause."%'";
					break;
				default:
					$sql .= "";
					break;
			}

			$result = mysql_query($sql);
			while($row = mysql_fetch_array($result)){				
				$red = ImageColorAllocate($image, 255, 0, 0);
				$tempx = floor($row['CoordX']/$this->reduction);
				$tempy = floor($row['CoordY']/$this->reduction);
				imagerectangle ($image, $tempx,$tempy,$tempx+1,$tempy+1, $red);				
			}				
					
			header("Content-Type: image/png");
			ImagePng($image);
			ImageDestroy($image);
		}
		
		public function showUsers(){
			$sql = "SELECT DISTINCT Session FROM clicktale";
			$result = mysql_query($sql);
			while($row = mysql_fetch_array($result)){				
				echo '<a href="click-tale.php?selector=1&clause='.$row['Session'].'">On User: '.$row['Session'].'</a><br />';			
			}			
		}
		
		public function showUrl(){
			$sql = "SELECT DISTINCT URL FROM clicktale";
			$result = mysql_query($sql);
			while($row = mysql_fetch_array($result)){				
				echo '<a href="click-tale.php?selector=2&clause='.$row['URL'].'">On User: '.$row['URL'].'</a><br />';			
			}			
		}		
		
		public function showDate(){
			$sql = "SELECT DISTINCT EXTRACT(YEAR FROM CreateDate) AS CYear, EXTRACT(MONTH FROM CreateDate) AS CMonth, EXTRACT(DAY FROM CreateDate) AS CDay FROM clicktale";
			$result = mysql_query($sql);
			while($row = mysql_fetch_array($result)){	
				$tmpdate = $row['CYear']."-".self::number_pad($row['CMonth'],2)."-".self::number_pad($row['CDay'],2);
				echo '<a href="click-tale.php?selector=3&clause='.$tmpdate.'">On Date: '.$tmpdate.'</a><br />';					
			}			
		}		
		
		public function showSelect(){
			echo '<br />';
			echo '<a href="click-tale.php?selector=1">Show by users</a><br />';
			echo '<a href="click-tale.php?selector=2">Show by URL</a><br />';
			echo '<a href="click-tale.php?selector=3">Show by Date</a><br />';
			echo '<a href="click-tale.php?selector=0">Show all</a><br />';
		}
		
		public function number_pad($number,$n){
			return str_pad((int) $number,$n,"0",STR_PAD_LEFT);
		}		
	}
	
	$clicktale = new clicktale();
	if(isset($_REQUEST['x']) && isset($_REQUEST['y']) && isset($_REQUEST['url'])){
		$clicktale->logClick($_REQUEST['x'],$_REQUEST['y'],$_REQUEST['url']);
	} else {		
		if(isset($_REQUEST['selector']) && !isset($_REQUEST['clause'])){
			switch($_REQUEST['selector']){
				case 1:
					$clicktale->showUsers();
					break;
				case 2:
					$clicktale->showUrl();
					break;
				case 3:
					$clicktale->showDate();
					break;
				default:	
					$clicktale->createImage(0,0);
					break;
			}	
		}
		if(isset($_REQUEST['clause'])){
			$clicktale->createImage($_REQUEST['selector'],$_REQUEST['clause']);
		} else {
			$clicktale->showSelect();
		}		
	}
?>