﻿<%@ Page Title="Home Page" Language="C#" MasterPageFile="~/Site.master" AutoEventWireup="true"
    CodeBehind="Default.aspx.cs" Inherits="WebApplication2._Default" %>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
   <style>
   body { font-family: arial; font-size: 14px; }
.liveExample { padding: 1em; background-color: #EEEEDD; border: 1px solid #CCC; max-width: 655px; }
.liveExample input { font-family: Arial; }
.liveExample b { font-weight: bold; }
.liveExample p { margin-top: 0.9em; margin-bottom: 0.9em; }
.liveExample select[multiple] { width: 100%; height: 8em; }
.liveExample h2 { margin-top: 0.4em; }

.ko-grid { margin-bottom: 1em; width: 25em; border: 1px solid silver; background-color:White; }
.ko-grid th { text-align:left; background-color: Black; color:White; }
.ko-grid td, th { padding: 0.4em; }
.ko-grid tr:nth-child(odd) { background-color: #DDD; }
.ko-grid-pageLinks { margin-bottom: 1em; }
.ko-grid-pageLinks a { padding: 0.5em; }
.ko-grid-pageLinks a.selected { background-color: Black; color: White; }
.liveExample { height:50em; overflow:auto } /* Mobile Safari reflows pages slowly, so fix the height to avoid the need for reflows */

li { list-style-type: disc; margin-left: 20px; }
   </style>
   <div class='liveExample'> 
    
    <p>Name: <input id="_name" value="New name" /></p>
    <p>Id: <input id="_id" value="1" /></p>
    <p>Price: <input id="_price" value="99" /></p>
    <button data-bind='click: addItem'>
        Add item
    </button>


    <div data-bind='simpleGrid: gridViewModel'> </div>
    
    
     
    <button data-bind='click: sortById'>
        Sort by id
    </button>
     
    <button data-bind='click: jumpToFirstPage, enable: gridViewModel.currentPageIndex'>
        First page
    </button>

    <button data-bind='click: jumpToLastPage'>
        Last page
    </button>
    
</div>​
 <script type="text/javascript">

     var ViewModel = function () {
         var self = this;
         this.initialized = ko.observable(false);
         this.items = new ko.observableArray();
         var sortAsc = true;

         this.addItem = function () {
             self.items.push({ name: ko.observable($("#_name").val()),
                 id: ko.observable($("#_id").val()),
                 price: ko.observable($("#_price").val())
             });
         };

         this.removeItem = function (item) {
             self.items.remove(item);
         };

         this.sortById = function () {
             this.items.sort(function (a, b) {
                 if (sortAsc)
                     return a.id() > b.id() ? -1 : 1;
                 else
                     return a.id() < b.id() ? -1 : 1;
             });

             sortAsc = !sortAsc;
         };

         this.jumpToFirstPage = function () {
             this.gridViewModel.currentPageIndex(0);
         };

         this.jumpToLastPage = function () {
             this.gridViewModel.currentPageIndex(this.gridViewModel.maxPageIndex() - 1);
         };

         this.gridViewModel = new ko.simpleGrid.viewModel({
             data: this.items,
             columns: [
                  { headerText: "Name", rowText: "name" },
                  { headerText: "Id", rowText: "id" },
                  { headerText: "Price", rowText: function (item) {
                      return "$" +
                        item.price()
                  } 
                  }
              ],
             pageSize: 10
         });

         $(document).ready(function () {
             $.ajax({ url: "/knockout/Handler1.ashx",
                 success: function (data) { 
                     ko.mapping.fromJS(data, {}, self.items);
                     self.initialized(true);
                 }
             });

         });

     }

     var vModel = new ViewModel()
     ko.applyBindings(vModel); 
                                 
</script>   
</asp:Content>
