using System;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

namespace PartialRendering
{
    public class TextWriter
    {

        static public string CreateTableHeader(string HeaderData)
        {
            return "<Table style='background-color:#0B5226; border:1px solid #306946;' width = '550px' ><Tr><Td colspan='3' style='font-family:Verdana, Arial, Helvetica, sans-serif; font-weight:bold; color:White; vertical-align:middle; text-align:center; font-size:20px; height:50px;'>" + HeaderData + "</Td></Tr></Table>";
        }

        static public string CreateTableRecord(ProcessingStatus Status, string Data, string TableName)
        {
            return "<Table style='border:1px solid #0B5226;background-color: white;' id=" + TableName + " runat='server' width = '550px'> <Tr style='font-family:Verdana, Arial, Helvetica, sans-serif; font-size:14px; font-weight:bold; color:#000000; vertical-align:middle; text-align:center;'><Td width='20%'> <img src=" + getProcessingImage(Status) + " alt=''/></Td><Td width='30%'>" + Data + "</Td><Td width='50%' style='text-align: left;'><Div>" + getProcessingMessage(Status) + "</Div></Td></Table>";
        }

        public enum ProcessingStatus
        {
            Success = 1,
            Fail = 2,
            Approval = 3,
            InProgress = 4,
        }

        public static string getProcessingImage(ProcessingStatus Icon)
        {
            switch (Icon)
            {
                case ProcessingStatus.Success:
                    return "'images/Success.png'";
                case ProcessingStatus.Fail:
                    return "'images/Error.png'";
                case ProcessingStatus.Approval:
                    return "'images/home_star.gif'";
                case ProcessingStatus.InProgress:
                    return "'images/Progress.gif'";
                
            }
            return "'images/Progress.gif'";
        }

        public static string getProcessingMessage(ProcessingStatus Icon)
        {
            switch (Icon)
            {
                case ProcessingStatus.Success:
                    return "Successful";
                case ProcessingStatus.Fail:
                    return "Failed";
                case ProcessingStatus.Approval:
                    return "Sent for approval";
                case ProcessingStatus.InProgress:
                    return "In Progress...";

            }
            return "'In Progress...'";
        }
    }

}
