﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace CssSpriteGenerator
{
    public class CombineRestrictionUtils
    {
        /// <summary>
        /// Returns true if the two given combine restrictions are combinable. That is, if
        /// two images with these restrictions could be combined into a sprite.
        /// </summary>
        /// <param name="cr1"></param>
        /// <param name="cr2"></param>
        /// <returns></returns>
        public static bool Combinable(CombineRestriction cr1, CombineRestriction cr2)
        {
            if ((cr1 == CombineRestriction.None) || (cr1 == CombineRestriction.Null) ||
                (cr2 == CombineRestriction.None) || (cr2 == CombineRestriction.Null))
            {
                // None and Null can be combined with anything
                return true;
            }

            // Neither is None or Null. So they must be the same in order to be combinable.
            return cr1 == cr2;
        }

        /// <summary>
        /// Returns the most restrictive of two combine restrictions.
        /// If they are equally restrictive, any of the two may be combined.
        /// 
        /// Note that this method does not check whether the two combine restrictions are actually
        /// combinable.
        /// </summary>
        /// <param name="cr1"></param>
        /// <param name="cr2"></param>
        /// <returns></returns>
        public static CombineRestriction MostRestrictive(CombineRestriction cr1, CombineRestriction cr2)
        {
            if ((cr1 == CombineRestriction.None) || (cr1 == CombineRestriction.Null))
            {
                return cr2;
            }

            if ((cr2 == CombineRestriction.None) || (cr2 == CombineRestriction.Null))
            {
                return cr1;
            }

            // Neither is None or Null, so they are both equally restrictive. Just pick one.
            return cr1;
        }

        /// <summary>
        /// Compares two combine restrictions.
        /// </summary>
        /// <param name="cr1"></param>
        /// <param name="cr2"></param>
        /// <returns>
        /// greater than 0: cr1 is more restrictive than cr2
        /// 0: they are both equally restrictive
        /// smaller than 0: cr1 is less restrictive than cr2
        /// </returns>
        public static int Compare(CombineRestriction cr1, CombineRestriction cr2)
        {
            if ((cr1 == CombineRestriction.None) || (cr1 == CombineRestriction.Null))
            {
                if ((cr2 == CombineRestriction.None) || (cr2 == CombineRestriction.Null))
                {
                    return 0;
                }
                else
                {
                    return -1;
                }
            }
            else
            {
                if ((cr2 == CombineRestriction.None) || (cr2 == CombineRestriction.Null))
                {
                    return 1;
                }
                else
                {
                    return 0;
                }
            }
        }
    }
}
