﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mapper
{
    /// <summary>
    /// Statistics gathered by a canvas.
    /// </summary>
    public interface ICanvasStats
    {
        /// <summary>
        /// Number of times an attempt was made to add an image to the canvas used by the mapper.
        /// </summary>
        int RectangleAddAttempts { get; set; }

        /// <summary>
        /// Number of cells generated by the canvas.
        /// </summary>
        int NbrCellsGenerated { get; set; }

        /// <summary>
        /// Each time a rectangle cannot be added because the canvas is not high enough,
        /// there is "free height deficit". The lowest of these free height deficits is recorded here.
        /// 
        /// This value is important, because if you try to put the same rectangles in a canvas
        /// whose height has not been increased by at 
        /// least this Lowest Missing Height, all rectangles will be placed in the exact same
        /// locations and you'll get the same outcome.
        /// 
        /// If there was never a failure to place a rectangle due to free height deficit, this will be Int32.MaxValue.
        /// </summary>
        int LowestFreeHeightDeficit { get; set; }
    }
}
