﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;

namespace CssSpriteGenerator
{
    /// <summary>
    /// An IImageReference is as reference to an image.
    /// It is used to pass references to images to the Generator.
    /// </summary>
    public interface IImageReference
    {
        /// <summary>
        /// Gets the full file path of the image.
        /// </summary>
        /// <returns></returns>
        string OriginalImageFilePath { get; }

        /// <summary>
        /// The width and height taken from the width and height properties of the image tag.
        /// If one or both properties were missing, than the property returns -1.
        /// </summary>
        Size SizeFromProperties { get; }

        /// <summary>
        /// Tells the IImageReference to replace the original image with a sprite.
        /// 
        /// That could mean replacing an img tag with a div tag that has an
        /// inlined style producing a background image.
        /// 
        /// Or it could mean creating a CSS definition that partially overrides
        /// another CSS definition that refers to the original image.
        /// 
        /// This method can be called only once on an IImageReference.
        /// </summary>
        /// <param name="spriteUrl">
        /// Url of the sprite. The sprite is an image in which one or more images have
        /// been combined, including the original image.
        /// </param>
        /// <param name="xOffset">
        /// X offset within the sprite where the original image starts.
        /// </param>
        /// <param name="yOffset">
        /// Y offset within the sprite where the original image starts.
        /// </param>
        /// <param name="imageWidth">
        /// Width in px of the original image.
        /// </param>
        /// <param name="imageHeight">
        /// Height in px of the original image.
        /// </param>
        /// <param name="overrideImgTagDimensionProperies">
        /// If the method decides to create an img tag for the sprite image (because there is only one
        /// image in the sprite), than if this is true, the width and height properties of the new img tag
        /// will be set from imageWidth and imageHeight. If this is false, than any width and height properties of the
        /// original img tag will be used.
        /// </param>
        /// <param name="additionalCss">
        /// If replacing the original image means that additional CSS needs to be sent to the browser
        /// (after the original CSS has been sent), add the additional CSS to this Stylesheet.
        /// 
        /// The caller of this method
        /// is responsible for putting the CSS in a stylesheet and having it linked to from the page.
        /// </param>
        /// <param name="nbrImagesInSprite">
        /// Number of images in the sprite identified by spriteUrl.
        /// </param>
        void ReplaceWithSprite(
            string spriteUrl, int xOffset, int yOffset, 
            int imageWidth, int imageHeight, bool overrideImgTagDimensionProperies,
            Stylesheet additionalCss, int nbrImagesInSprite);
    }
}
