﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;

namespace CssSpriteGenerator
{
    /// <summary>
    /// ImageReference used for images found in disk folders.
    /// </summary>
    public class Folder_ImageReference : IImageReference
    {
        private string _originalImageFilePath = null;

        public Folder_ImageReference(string originalImageFilePath)
        {
            _originalImageFilePath = originalImageFilePath;
        }

        #region IImageReference Members

        public string OriginalImageFilePath
        {
            get { return _originalImageFilePath; }
        }

        // Because the images are taken from disk folders rather than img tags, there are no width and height properties
        public Size SizeFromProperties { get { return new Size(-1,-1); } }

        // This method does nothing here, because we're not going to update physical image files
        public void ReplaceWithSprite(
            string spriteUrl, int xOffset, int yOffset, int imageWidth, int imageHeight, bool overrideImgTagDimensionProperties,
            Stylesheet additionalCss, int nbrImagesInSprite)
        {
        }

        #endregion
    }
}
