﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;

namespace CssSpriteGenerator
{
    public class Css_ImageReference : IImageReferenceWithCombineTypeRestriction
    {
        private CssImage _cssImage = null;
        private string _originalImageFilePath = null;
        private ConfigSection _cs = null;

        public Css_ImageReference(CssImage cssImage, ConfigSection cs)
        {
            _cssImage = cssImage;
            _cs = cs;
            _originalImageFilePath = UrlUtils.MapPath(_cssImage.ImageUrl, ConfigSection.OptionIsActive(cs.ExceptionOnMissingFile));
        }

        #region IImageReferenceWithCombineTypeRestriction Members

        public string OriginalImageFilePath
        {
            get { return _originalImageFilePath; }
        }

        public Size SizeFromProperties { get { return new Size(-1,-1); } }

        public void ReplaceWithSprite(
            string spriteUrl, int xOffset, int yOffset, int imageWidth, int imageHeight, bool overrideImgTagDimensionProperties,
            Stylesheet additionalCss, int nbrImagesInSprite)
        {
            string cssDeclaration = HtmlUtils.CssSpriteCss(spriteUrl, xOffset, yOffset, _cssImage.BackgroundAlignment);

            additionalCss.AddDefinition(_cssImage.CssSelector, cssDeclaration);
        }

        public CombineRestriction CombineRestriction
        {
            get
            {
                if (_cssImage == null)
                {
                    return CombineRestriction.Null;
                }
                else
                {
                    return _cssImage.CombineRestriction;
                }
            }
        }

        #endregion
    }
}
