﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Configuration;
using System.Drawing.Imaging;

namespace CssSpriteGenerator
{
    public class GroupConfigurationElement : ConfigurationElement
    {
        private static ConfigurationProperty _maxSize;
        private static ConfigurationProperty _maxWidth;
        private static ConfigurationProperty _maxHeight;
        private static ConfigurationProperty _maxPixelFormat;
        private static ConfigurationProperty _filePathMatch;
        private static ConfigurationProperty _maxSpriteSize;
        private static ConfigurationProperty _spriteImageType;
        private static ConfigurationProperty _groupName;
        private static ConfigurationProperty _subsetOf;

        private static ConfigurationProperty _pageUrlMatch;
        private static ConfigurationProperty _resizeWidth;
        private static ConfigurationProperty _resizeHeight;
        private static ConfigurationProperty _jpegQuality;
        private static ConfigurationProperty _pixelFormat;
        private static ConfigurationProperty _paletteAlgorithm;
        private static ConfigurationProperty _giveOwnSprite;
        private static ConfigurationProperty _disableAutoResize;
        private static ConfigurationProperty _sameImageType;
        private static ConfigurationProperty _samePixelFormat;

        private static ConfigurationPropertyCollection _properties;

        static GroupConfigurationElement()
        {
            _maxSize = new ConfigurationProperty(
                "maxSize",
                typeof(int?)
            );

            _maxWidth = new ConfigurationProperty(
                "maxWidth",
                typeof(int?)
            );

            _maxHeight = new ConfigurationProperty(
                "maxHeight",
                typeof(int?)
            );

            _maxPixelFormat = new ConfigurationProperty(
                "maxPixelFormat",
                typeof(PixelFormat?)
            );

            _filePathMatch = new ConfigurationProperty(
                "filePathMatch",
                typeof(string)
            );

            _maxSpriteSize = new ConfigurationProperty(
                "maxSpriteSize",
                typeof(int?)
            );

            _spriteImageType = new ConfigurationProperty(
                "spriteImageType",
                typeof(ImageType)
            );

            _groupName = new ConfigurationProperty(
                "groupName",
                typeof(string)
            );

            _subsetOf = new ConfigurationProperty(
                "subsetOf",
                typeof(string)
            );

            _pageUrlMatch = new ConfigurationProperty(
                "pageUrlMatch",
                typeof(string)
            );

            _sameImageType = new ConfigurationProperty(
                "sameImageType",
                typeof(bool?)
            );

            _samePixelFormat = new ConfigurationProperty(
                "samePixelFormat",
                typeof(bool?)
            );

            _resizeWidth = new ConfigurationProperty(
                "resizeWidth",
                typeof(int?)
            );

            _resizeHeight = new ConfigurationProperty(
                "resizeHeight",
                typeof(int?)
            );

            _jpegQuality = new ConfigurationProperty(
                "jpegQuality",
                typeof(int?)
            );

            _pixelFormat = new ConfigurationProperty(
                "pixelFormat",
                typeof(PixelFormat?)
            );

            _paletteAlgorithm = new ConfigurationProperty(
                "paletteAlgorithm",
                typeof(PaletteAlgorithm?)
            );

            _giveOwnSprite = new ConfigurationProperty(
                "giveOwnSprite",
                typeof(bool?)
            );

            _disableAutoResize = new ConfigurationProperty(
                "disableAutoResize",
                typeof(bool?)
            );

            _properties = new ConfigurationPropertyCollection();
            _properties.Add(_maxSize);
            _properties.Add(_maxWidth);
            _properties.Add(_maxHeight);
            _properties.Add(_filePathMatch);
            _properties.Add(_maxSpriteSize);
            _properties.Add(_spriteImageType);
            _properties.Add(_groupName);
            _properties.Add(_subsetOf);
            _properties.Add(_pageUrlMatch);
            _properties.Add(_maxPixelFormat);
            _properties.Add(_sameImageType);
            _properties.Add(_samePixelFormat);
            _properties.Add(_resizeWidth);
            _properties.Add(_resizeHeight);
            _properties.Add(_jpegQuality);
            _properties.Add(_pixelFormat);
            _properties.Add(_paletteAlgorithm);
            _properties.Add(_giveOwnSprite);
            _properties.Add(_disableAutoResize);
        }

        // Note that the DefaultValue propery of ConfigurationPropertyAttribute simply doesn't work.
        // Instead, use the technique shown here:
        // http://social.msdn.microsoft.com/Forums/en-US/netfxbcl/thread/061b7319-ab9c-4d60-9ee4-28aec1491acb

        [ConfigurationProperty("maxSize", IsRequired = false)]
        public int? MaxSize
        {
            // Should you ever want to make this into a long?, note that casting base[....] 
            // to long? directly results in a "specified cast is not valid" exception.
            get { return (int?)base[new ConfigurationProperty("maxSize", typeof(int?), null)]; }
        }

        [ConfigurationProperty("maxWidth", IsRequired = false)]
        public int? MaxWidth
        {
            get { return (int?)base[new ConfigurationProperty("maxWidth", typeof(int?), null)]; }
        }

        [ConfigurationProperty("maxHeight", IsRequired = false)]
        public int? MaxHeight
        {
            get { return (int?)base[new ConfigurationProperty("maxHeight", typeof(int?), null)]; }
        }

        [ConfigurationProperty("filePathMatch", IsRequired = false)]
        public string FilePathMatch
        {
            get { return (string)base[new ConfigurationProperty("filePathMatch", typeof(string), null)]; }
        }

        [ConfigurationProperty("maxSpriteSize", IsRequired = false)]
        public int? MaxSpriteSize 
        {
            get { return (int?)base[new ConfigurationProperty("maxSpriteSize", typeof(int?), null)]; }
        }

        [ConfigurationProperty("maxPixelFormat", IsRequired = false)]
        public PixelFormat? MaxPixelFormat
        {
            get { return (PixelFormat?)base[new ConfigurationProperty("maxPixelFormat", typeof(PixelFormat?), null)]; }
        }

        [ConfigurationProperty("sameImageType", IsRequired = false)]
        public bool? SameImageType
        {
            get { return (bool?)base[new ConfigurationProperty("sameImageType", typeof(bool?), null)]; }
        }

        [ConfigurationProperty("samePixelFormat", IsRequired = false)]
        public bool? SamePixelFormat
        {
            get { return (bool?)base[new ConfigurationProperty("samePixelFormat", typeof(bool?), null)]; }
        }

        [ConfigurationProperty("spriteImageType", IsRequired = false)]
        public ImageType SpriteImageType
        {
            get { return (ImageType)base[new ConfigurationProperty("spriteImageType", typeof(ImageType), ImageType.Null)]; }
        }

        [ConfigurationProperty("groupName", IsRequired = false)]
        public string GroupName
        {
            get { return (string)base[new ConfigurationProperty("groupName", typeof(string), null)]; }
        }

        [ConfigurationProperty("subsetOf", IsRequired = false)]
        public string SubsetOf
        {
            get { return (string)base[new ConfigurationProperty("subsetOf", typeof(string), null)]; }
        }

        [ConfigurationProperty("pageUrlMatch", IsRequired = false)]
        public string PageUrlMatch
        {
            get { return (string)base[new ConfigurationProperty("pageUrlMatch", typeof(string), null)]; }
        }

        [ConfigurationProperty("resizeWidth", IsRequired = false)]
        public int? ResizeWidth
        {
            get { return (int?)base[new ConfigurationProperty("resizeWidth", typeof(int?), null)]; }
        }

        [ConfigurationProperty("resizeHeight", IsRequired = false)]
        public int? ResizeHeight
        {
            get { return (int?)base[new ConfigurationProperty("resizeHeight", typeof(int?), null)]; }
        }

        [ConfigurationProperty("jpegQuality", IsRequired = false)]
        public int? JpegQuality
        {
            get { return (int?)base[new ConfigurationProperty("jpegQuality", typeof(int?), null)]; }
        }

        [ConfigurationProperty("pixelFormat", IsRequired = false)]
        public PixelFormat? PixelFormat
        {
            get { return (PixelFormat?)base[_pixelFormat]; }
        }

        [ConfigurationProperty("paletteAlgorithm", IsRequired = false)]
        public PaletteAlgorithm? PaletteAlgorithm
        {
            get { return (PaletteAlgorithm?)base[new ConfigurationProperty("paletteAlgorithm", typeof(PaletteAlgorithm?), null)]; }
        }

        [ConfigurationProperty("giveOwnSprite", IsRequired = false)]
        public bool? GiveOwnSprite
        {
            get { return (bool?)base[_giveOwnSprite]; }
        }

        [ConfigurationProperty("disableAutoResize",  IsRequired = false)]
        public bool? DisableAutoResize
        {
            get { return (bool?)base[_disableAutoResize]; }
        }

        protected override ConfigurationPropertyCollection Properties
        {
            get { return _properties; }
        }
    }
}
