﻿using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.SessionState;
using CustomPermission.Model;

namespace CustomPermission.Class
{
    public class PermissionControl
    {
        private static readonly HttpSessionState Session = HttpContext.Current.Session;
        private static readonly HttpApplicationState Application = HttpContext.Current.Application;
        
        public static bool CheckPermission(string PermissionConstantName)
        {
            bool result = false;

            // Is current visitor logged in?
            if (!HttpContext.Current.User.Identity.IsAuthenticated)
            {
                return false;
            }

            string Username = HttpContext.Current.User.Identity.Name;

            //if in user permissions you make changes, you have to clear his permission list
            if (Application["AffectedUsers"] != null)
            {
                var AffectedUsers = (List<string>) Application["AffectedUsers"];
                if (AffectedUsers.Contains(Username))
                {
                    Session["PermissionList"] = null;
                    AffectedUsers.Remove(Username);
                    Application["AffectedUsers"] = AffectedUsers;
                }
            }

            Users CurrentUser =
                (from user in DataContext.Context.Users where user.Username == Username select user).
                    SingleOrDefault();

            //return True because SuperAdmin has all the permissions!
            if (CurrentUser.IsSuperAdmin)
            {
                return true;
            }

            if (Session["PermissionList"] == null)
            {
                List<string> PermissionList = (from p in DataContext.Context.Permissions
                                               join rp in DataContext.Context.RolePermissions on p.PermissionID
                                                   equals
                                                   rp.PermissionID
                                               join r in DataContext.Context.Roles on rp.RoleID equals r.RoleID
                                               join ur in DataContext.Context.UserRoles on r.RoleID equals
                                                   ur.RoleID
                                               where ur.UserID == CurrentUser.UserID
                                               select p.PermissionConstantName).Distinct().ToList();

                Session["PermissionList"] = PermissionList;

                result = PermissionList.Contains(PermissionConstantName);
            }
            else
            {
                var PermissionList = (List<string>) Session["PermissionList"];
                result = PermissionList.Contains(PermissionConstantName);
            }

            return result;
        }
    }
}