﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using CustomPermission.Model;

namespace CustomPermission.Admin
{
    public partial class WebForm1 : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            int roleID = Convert.ToInt32(ViewState["RoleID"]);
            
            //e.Result = PermissionGroups.Union(Permissions).ToList();

        }

        protected void grdroles_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            ViewState["RoleID"] = e.CommandArgument;
            int roleID = Convert.ToInt32(e.CommandArgument);
            var role = (from r in DataContext.Context.Roles
                        where r.RoleID == roleID
                        select r).FirstOrDefault();

            txtRoleTitle.Text = role.RoleTitle;

            var Permissions = (from p in DataContext.Context.Permissions.AsEnumerable()
                               select new ListItem
                                          {
                                              Value = p.PermissionID.ToString(),
                                              Text = p.PermissionTitle,
                                              Selected = (from rp in DataContext.Context.RolePermissions
                                                                                     where rp.RoleID == roleID &&
                                                                                           rp.PermissionID == p.PermissionID
                                                                                     select rp).Count() != 0
                                          }).ToList();
            txtRoleTitle.Text = role.RoleTitle;
            ViewState["RoleID"] = roleID;
            ViewState["EditMode"] = "Edit";
            chblpermissions.Items.Clear();
            foreach (var permission in Permissions)
            {
                chblpermissions.Items.Add(permission);
            }
            MultiView1.SetActiveView(vweditrolepermission);
        }

        protected void btncancel_Click(object sender, EventArgs e)
        {
            MultiView1.SetActiveView(vwshowRole);
        }

        protected void btnsave_Click(object sender, EventArgs e)
        {
            if (Page.IsValid)
            {
                switch (ViewState["EditMode"].ToString())
                {
                    case "Insert":
                        {
                            Roles role = new Roles()
                            {
                                RoleTitle = txtRoleTitle.Text
                            };
                            DataContext.Context.Roles.AddObject(role);

                            foreach (ListItem item in chblpermissions.Items)
                            {
                                if (item.Selected)
                                {
                                    RolePermissions rp = new RolePermissions()
                                                            {
                                                                RoleID = role.RoleID,
                                                                PermissionID = Convert.ToInt32(item.Value)
                                                            };
                                    DataContext.Context.RolePermissions.AddObject(rp); 
                                }
                            }
                            DataContext.Context.SaveChanges();
                            break;
                        }
                    case "Edit":
                        {
                            int roleID = Convert.ToInt32(ViewState["RoleID"]);

                            var role = (from r in DataContext.Context.Roles
                                        where r.RoleID == roleID
                                        select r).FirstOrDefault();

                            role.RoleTitle = txtRoleTitle.Text;

                            // Delete current permissions of the role
                            (from r in DataContext.Context.RolePermissions
                             where r.RoleID == roleID
                             select r).ToList().ForEach(DataContext.Context.DeleteObject);

                            // Insert new role permissions
                            foreach (ListItem item in chblpermissions.Items)
                            {
                                if (item.Selected)
                                {
                                    RolePermissions rp = new RolePermissions()
                                                            {
                                                                RoleID = role.RoleID,
                                                                PermissionID = Convert.ToInt32(item.Value)
                                                            };
                                    DataContext.Context.RolePermissions.AddObject(rp);
                                }
                            }

                            // Get List of Users in current role, to reload their permissions
                            List<string> AffectedUsers = (from user in DataContext.Context.Users
                                                          join userrole in DataContext.Context.UserRoles on user.UserID
                                                              equals userrole.UserID
                                                          where userrole.RoleID == roleID
                                                          select user.Username).ToList();

                            if (Application["AffectedUsers"] == null)
                            {
                                Application["AffectedUsers"] = AffectedUsers;
                            }
                            else
                            {
                                List<string> ExistingAffectedUsers = (List<string>)Application["AffectedUsers"];
                                foreach (string affectedUsername in AffectedUsers)
                                {
                                    if (!ExistingAffectedUsers.Contains(affectedUsername))
                                    {
                                        ExistingAffectedUsers.Add(affectedUsername);
                                    }
                                }
                            }

                            DataContext.Context.SaveChanges();

                            break;
                        }
                }
                MultiView1.SetActiveView(vwshowRole);
                grdroles.DataBind();
            }
        }

        protected void LinkButton1_Click(object sender, EventArgs e)
        {
            var Permissions = (from p in DataContext.Context.Permissions.AsEnumerable()
                               select new ListItem
                               {
                                   Value = p.PermissionID.ToString(),
                                   Text = p.PermissionTitle,
                                   Selected = false
                               }).ToList();

            txtRoleTitle.Text = string.Empty;
            chblpermissions.Items.Clear();
            foreach (var permission in Permissions)
            {
                chblpermissions.Items.Add(permission);
            }
            ViewState["EditMode"] = "Insert";
            MultiView1.SetActiveView(vweditrolepermission);
        }
    }
}