﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using CustomPermission.Model;

namespace CustomPermission.Admin
{
    public partial class MangeUsers : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {

        }

        protected void GridView1_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            int userID = Convert.ToInt32(e.CommandArgument);

            var user = (from u in DataContext.Context.Users
                        where u.UserID == userID
                        select u).FirstOrDefault();

            txtUsername.Text = user.Username;
            txtPassword.Text = user.Password;
            txtEmail.Text = user.Email;

            ViewState["UserID"] = userID;
            ViewState["EditMode"] = "Edit";

            cblRoles.DataBind();

            // Now check the roles of current user in checkbox
            var userRoles = (from ur in DataContext.Context.UserRoles
                             where ur.UserID == userID
                             select ur.RoleID);

            foreach (ListItem item in cblRoles.Items)
            {
                if (userRoles.Contains(Convert.ToInt32(item.Value)))
                {
                    item.Selected = true;
                }
            }

            mvRoles.SetActiveView(vwEdit);

        }

        protected void lbAdd_Click(object sender, EventArgs e)
        {

            txtUsername.Text = string.Empty;
            txtPassword.Text = string.Empty;
            txtEmail.Text = string.Empty;

            ViewState["EditMode"] = "Insert";

            cblRoles.DataBind();

            mvRoles.SetActiveView(vwEdit);
                
        }
        protected void btnCancel_Click(object sender, EventArgs e)
        {
            mvRoles.SetActiveView(vwList);
        }

        protected void btnSave_Click(object sender, EventArgs e)
        {
            if (Page.IsValid)
            {
                switch (ViewState["EditMode"].ToString())
                {
                    case "Insert":
                        {
                            Users user = new Users()
                            {
                                Username = txtUsername.Text,
                                Password = txtPassword.Text,
                                Email = txtEmail.Text,
                                IsSuperAdmin = false
                            };
                            DataContext.Context.Users.AddObject(user);

                            foreach (ListItem item in cblRoles.Items)
                            {
                                if (item.Selected)
                                {
                                    UserRoles ur = new UserRoles()
                                    {
                                        UserID = user.UserID,
                                        RoleID = Convert.ToInt32(item.Value)
                                    };
                                    DataContext.Context.UserRoles.AddObject(ur);
                                }
                            }
                            DataContext.Context.SaveChanges();
                            break;
                        }
                    case "Edit":
                        {
                            int userID = Convert.ToInt32(ViewState["UserID"]);

                            var user = (from u in DataContext.Context.Users
                                        where u.UserID == userID
                                        select u).FirstOrDefault();

                            user.Username = txtUsername.Text;
                            user.Password = txtPassword.Text;
                            user.Email = txtEmail.Text;

                            // Delete current permissions of the role
                            (from ur in DataContext.Context.UserRoles
                             where ur.UserID == userID
                             select ur).ToList().ForEach(DataContext.Context.DeleteObject);

                            // Insert new roles for this user
                            foreach (ListItem item in cblRoles.Items)
                            {
                                if (item.Selected)
                                {
                                    UserRoles ur = new UserRoles()
                                    {
                                        UserID = user.UserID,
                                        RoleID = Convert.ToInt32(item.Value)
                                    };
                                    DataContext.Context.UserRoles.AddObject(ur);
                                }
                            }
                            DataContext.Context.SaveChanges();

                            break;
                        }
                }
                mvRoles.SetActiveView(vwList);
                GridView1.DataBind();
            }
        }
    }
}