﻿using System.Web.Mvc;

namespace MVCToolkitHelpers
{
    public static class ViedoExtension
    {
        public static MvcHtmlString Video(this HtmlHelper html, string src, bool showControls)
        {
            string url = UrlHelper.GenerateContentUrl(src, html.ViewContext.HttpContext);
            var tag = new TagBuilder("video") {InnerHtml = "Your browser doesn't support video tags."};

            tag.MergeAttribute("src", url);
            if(showControls)
                tag.MergeAttribute("controls", "controls"); // Show Play/Pause buttons
            return MvcHtmlString.Create(tag.ToString());
        }
    }
}
