﻿using System.IO;
using System.Web.Mvc;
using SquishIt.Framework.JavaScript;
using SquishIt.Framework.Minifiers;
using SquishIt.Framework.Minifiers.JavaScript;

namespace TestJavascriptLocalizationOfExternalFiles.Controllers
{
    public class JsController : Controller
    {
        // Remember to manage the cache here
        public JavaScriptResult Index(string js, string lang, string ver)
        {
            Response.ContentType = "text/javascript";

            var script = RenderRazorViewToString(js, null);

            var jsRet = new JavaScriptResult();

            script = script
                .Replace("<script type=\"text/javascript\">", string.Empty)
                .Replace("<script>", string.Empty)
                .Replace("</script>", string.Empty);

            var javaScriptMinifier = MinifierFactory.Get<JavaScriptBundle, JsMinMinifier>();
            string minifiedJavaScript = javaScriptMinifier.Minify(script);

            jsRet.Script = minifiedJavaScript;

            return jsRet;
        }

        private string RenderRazorViewToString(string viewName, object model)
        {
            ViewData.Model = model;
            using (var sw = new StringWriter())
            {
                var viewResult = ViewEngines.Engines.FindPartialView(ControllerContext, viewName);
                var viewContext = new ViewContext(ControllerContext, viewResult.View, ViewData, TempData, sw);
                viewResult.View.Render(viewContext, sw);
                viewResult.ViewEngine.ReleaseView(ControllerContext, viewResult.View);
                return sw.GetStringBuilder().ToString();
            }
        }

    }
}
