﻿' Code Reference: http://www.codeproject.com/Articles/42183/How-to-post-back-to-the-server-using-JavaScript-in

Imports System.Collections.Generic
Imports System.Text
Imports System.Web
Imports System.Web.UI.WebControls
Imports System.Web.UI.HtmlControls
Imports System.Web.Security
Imports System.Web.UI

Public Class JavaScriptPostback
    Inherits CompositeControl

#Region "Properties"
    Public Property CausesValidation() As [Boolean]
        Get
            If ViewState("CausesValidation") Is Nothing Then
                Return False
            End If

            Return CType(ViewState("CausesValidation"), [Boolean])
        End Get
        Set(value As [Boolean])
            ViewState("CausesValiation") = value
        End Set
    End Property

    Public Property ValidationGroup() As [String]
        Get
            If ViewState("ValidationGroup") Is Nothing Then
                Return [String].Empty
            End If

            Return DirectCast(ViewState("ValidationGroup"), [String])
        End Get
        Set(value As [String])
            ViewState("ValidationGroup") = value
        End Set
    End Property

    Public Property FunctionName() As [String]
        Get
            If ViewState("FunctionName") Is Nothing Then
                Throw New ApplicationException([String].Format("{0} must specify a function name", Me.ID))
            End If

            Return DirectCast(ViewState("FunctionName"), [String])
        End Get
        Set(value As [String])
            ViewState("FunctionName") = value
        End Set
    End Property

    Public Property JavaScriptNamespaces() As [String]
        Get
            If ViewState("JavaScriptNamespaces") Is Nothing Then
                Return [String].Empty
            End If

            Return DirectCast(ViewState("JavaScriptNamespaces"), [String])
        End Get
        Set(value As [String])
            ViewState("JavaScriptNamespaces") = value
        End Set
    End Property

    Public Event Postback As EventHandler(Of JavaScriptPostbackEventArgs)

#End Region

    Protected Overrides Sub CreateChildControls()
        Controls.Clear()
        CreateControlHierarchy()
        ClearChildViewState()
    End Sub

    Protected Overridable Sub CreateControlHierarchy()
        Controls.Add(PostbackButton)
        AddHandler PostbackButton.Click, New EventHandler(AddressOf PostbackButton_Click)
    End Sub

    Private _postbackButton As Button
    Private ReadOnly Property PostbackButton() As Button
        Get
            If _postbackButton Is Nothing Then
                _postbackButton = New Button()
                _postbackButton.ID = "PostbackButton"
                _postbackButton.Style.Add("display", "none")

            End If

            Return _postbackButton
        End Get
    End Property

    Private Sub PostbackButton_Click(sender As Object, e As EventArgs)        
        RaiseEvent Postback(sender, New JavaScriptPostbackEventArgs(HttpContext.Current.Request("__EVENTARGUMENT")))
    End Sub

    Protected Overrides Sub Render(writer As HtmlTextWriter)
        MyBase.Render(writer)
        Dim options As New PostBackOptions(PostbackButton)
        options.PerformValidation = Me.CausesValidation
        options.ValidationGroup = Me.ValidationGroup
        options.Argument = "arg"

        Dim functionName__1 As [String] = If(JavaScriptNamespaces.Equals([String].Empty), FunctionName, [String].Concat(JavaScriptNamespaces, ".", FunctionName))
        Dim arg As String = "e"
        writer.Write("<script type='text/javascript'>")
        AddNamespaces(JavaScriptNamespaces, writer)
        writer.Write([String].Format("{0} = function(arg) {1}", functionName__1, "{"))
        writer.Write(Me.Page.ClientScript.GetPostBackEventReference(options).Replace("'arg'", "arg"))
        writer.Write("};")
        writer.Write("</script>")
        Me.Page.ClientScript.RegisterForEventValidation(options)
    End Sub

    Private Sub AddNamespaces(originalNamespaces As [String], output As System.Web.UI.HtmlTextWriter)
        Dim namespaces As New StringBuilder()
        If Not originalNamespaces.Equals([String].Empty) Then
            Dim namespaceList As [String]() = originalNamespaces.Split("."c)
            For Each nspace As [String] In namespaceList
                If namespaces.Length > 0 Then
                    namespaces.Append(".")
                End If

                namespaces.Append(nspace)

                output.WriteLine([String].Concat("if (typeof(", namespaces.ToString(), ") === 'undefined') { ", namespaces.ToString(), " = {}; }"))
            Next
        End If
    End Sub
End Class

Public Class JavaScriptPostbackEventArgs
    Inherits EventArgs

    Public args As String = ""

    Public Sub New(args As String)
        Me.args = args
    End Sub
End Class