﻿using System;
using SerializedDataSample.Models;

namespace SerializedDataSample.Services
{
    public class StockMarketService
    {
        public Quote GetQuote(string code)
        {
            var price = new Random().Next(100, 1000);
            return new Quote
                       {
                           Code = code,
                           LastTradePrice = price,
                           LastTradeTime = DateTime.Now.AddMinutes(-10),
                           Bid = (int)(price - (price * 0.1)),
                           Ask = (int)(price + (price * 0.1)),
                           Volume = new Random().Next(10000, 100000),
                       };
        }
    }
}