﻿using System.Text;
using System.Web.Mvc;
using SerializedDataSample.Services;

namespace SerializedDataSample.Controllers
{
    public class StockMarketController : Controller
    {
        public SerializedDataResult AutoQuote(string code)
        {
            var svc = new StockMarketService();
            return this.Serialize(svc.GetQuote(code), SerializedDataRequestBehavior.AllowGet);
        }

        public SerializedDataResult JsonQuote(string code)
        {
            var svc = new StockMarketService();
            return this.Serialize(
                svc.GetQuote(code),
                SerializedDataFormat.Json,
                null, null, null,
                SerializedDataRequestBehavior.AllowGet);
        }

        public SerializedDataResult XmlQuote(string code)
        {
            var svc = new StockMarketService();
            return this.Serialize(
                svc.GetQuote(code),
                SerializedDataFormat.Xml,
                null, null, null,
                SerializedDataRequestBehavior.AllowGet);
        }

        public SerializedDataResult ComplexQuote(string code)
        {
            var svc = new StockMarketService();
            return this.Serialize(
                svc.GetQuote(code),
                SerializedDataFormat.Auto,
                "dataformat",
                "application/quoteserver",
                Encoding.Unicode,
                SerializedDataRequestBehavior.AllowGet);
        }
    }
}
