using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

namespace DynamicMasterPages
{

    public partial class MasterPage : System.Web.UI.MasterPage
    {
        int num;

        public MasterPage()
        {
            object cphnum = HttpContext.Current.Session["cphnum"];
            if (cphnum == null || !(cphnum is int))
                return;
            num = (int)cphnum;
            //create the contentplaceholders to be paired with the content
            for (int i = 1; i < num + 1; i++)
                base.ContentPlaceHolders.Add("contentplaceholder" + i.ToString());
        }

        protected override void FrameworkInitialize()
        {
            //this code is required to run before the main master pages init, so a different event is used
            base.FrameworkInitialize();
      
            if (num == 0)
                return;
            //create the content just like for a page
            for (int i = 1; i < num + 1; i++)
                base.AddContentTemplate("ContentPlaceHolder" + i.ToString(), new CompiledTemplateBuilder(new BuildTemplateMethod(this.Build)));


        }

        private void Build(Control c)
        {
            Literal b = new Literal();
            b.ID = "Literal1";
            b.Text = "NestedMaster";
            c.Controls.Add(b);

            for (int i = 1; i < num + 1; i++)
            {
                ContentPlaceHolder cph = new ContentPlaceHolder();
                cph.ID = "ContentPlaceHolder" + i.ToString();
                c.Controls.Add(cph);
                //fill the content placeholders with content from content page
                //will throw NullReferenceException if content does not exist
                ((ITemplate)base.ContentTemplates["ContentPlaceHolder" + i.ToString()]).InstantiateIn(cph);
            }

        }
    }
}
