﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using System.Web.Configuration;

public partial class _Default : System.Web.UI.Page
{
    protected string MailhidePublicKey = string.Empty;
    protected string MailhidePrivateKey = string.Empty;
    protected bool ConfigurationValid = false;

    protected void Page_Load(object sender, EventArgs e)
    {
        // Get the Mailhide keys
        ConfigurationValid = GetConfigurationSettings();

        // Get the contacts to display
        List<Contact> contacts = GetContacts();

        // If the Mailhide keys are valid, encrypt each contact's email address
        if (ConfigurationValid)
        {
            using (Mailhide mailhide = new Mailhide(MailhidePrivateKey))
            {
                foreach (Contact contact in contacts)
                {
                    contact.Email = mailhide.EncryptEmail(contact.Email);
                }
                mailhide.Clear(); // Free up resources and zero out in-memory data
            }
        }

        // Bind the data to the Repeater control
        ContactsRepeater.DataSource = contacts;
        ContactsRepeater.DataBind();
    }

    public bool GetConfigurationSettings()
    {
        // Get the Mailhide keys from web.config
        MailhidePublicKey = WebConfigurationManager.AppSettings["MailhidePublicKey"];
        MailhidePrivateKey = WebConfigurationManager.AppSettings["MailhidePrivateKey"];

        // Ensure that the Mailhide keys have been set
        if (MailhidePublicKey == "Your Mailhide public key")
        {
            return false;
        }

        return true;
    }

    // Contact Information
    public class Contact
    {
        public string FirstName { get; set; }
        public string LastName { get; set; }
        public string Company { get; set; }
        public string Title { get; set; }
        public string Phone { get; set; }
        public string Email { get; set; }
    }

    public List<Contact> GetContacts()
    {
        // Load some sample contacts

        List<Contact> contacts = new List<Contact>();

        contacts.Add(new Contact()
        {
            FirstName = "John",
            LastName = "Doe",
            Company = "Example Company",
            Title = "CEO",
            Phone = "222-333-4444",
            Email = "johndoe@example.com",
        });

        contacts.Add(new Contact()
        {
            FirstName = "Jane",
            LastName = "Smith",
            Company = "Example Company",
            Title = "Vice President",
            Phone = "222-333-5555",
            Email = "janesmith@example.com"
        });

        contacts.Add(new Contact()
        {
            FirstName = "Bob",
            LastName = "Taylor",
            Company = "Example Company",
            Title = "Sales Manager",
            Phone = "222-333-6666",
            Email = "bobtaylor@example.com"
        });

        return contacts;
    }
}
