﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="Default.aspx.cs" Inherits="_Default" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Mailhide Demo</title>
    <script src="http://ajax.aspnetcdn.com/ajax/jquery/jquery-1.5.1.min.js" type="text/javascript"></script>
    <script type="text/javascript">
        $(function () {
            $('a:[href*=mailhide]').click(function (event) {
                event.preventDefault();
                window.open($(this).attr('href'), '',
                'toolbar=0,scrollbars=0,location=0,statusbar=0,menubar=0,resizable=0,width=500,height=300');
            });
        });
    </script>
</head>
<body>
    <form id="form1" runat="server">
    <h1>
        Mailhide Demo</h1>
    <% if (!ConfigurationValid)
       { %>
    <div>
        Please update the web.config file with your <a href='http://www.google.com/recaptcha/mailhide/apikey'>
            Google Mailhide keys</a><br />
        <br />
    </div>
    <% } %>
    <div>
        <asp:Repeater ID="ContactsRepeater" runat="server">
            <HeaderTemplate>
                <b>Contacts:</b><br />
                <br />
            </HeaderTemplate>
            <ItemTemplate>
                <%# Eval("FirstName") %>
                <%# Eval("LastName") %><br />
                <%# Eval("Title") %><br />
                <%# Eval("Company") %><br />
                <%# Eval("Phone") %>
                <% if (ConfigurationValid)
                   { %>
                <br />
                <a href="http://www.google.com/recaptcha/mailhide/d?k=<%= MailhidePublicKey %>&c=<%# Eval("Email") %>"
                    title="Email this contact">Email this contact</a>
                <% } %>
            </ItemTemplate>
            <SeparatorTemplate>
                <br />
                <br />
            </SeparatorTemplate>
        </asp:Repeater>
    </div>
    </form>
</body>
</html>
