﻿// -- FILE ------------------------------------------------------------------
// name       : VirtualUserForm.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;
using System.Web.UI;
using System.Web.Hosting;
using System.Collections.Generic;
using Itenso.WebUserForms.Controls;
using Itenso.WebUserForms.Runtime;

// --------------------------------------------------------------------------
public partial class VirtualPage : Page
{

	// ------------------------------------------------------------------------
	private string WorkingFormName
	{
		get { return ViewState[ "WorkingForm" ] as string; }
		set { ViewState[ "WorkingForm" ] = value; }
	} // WorkingFormName

	// ------------------------------------------------------------------------
	private static VirtualUserFormFileProvider FormProvider
	{
		get { return HostingEnvironment.VirtualPathProvider as VirtualUserFormFileProvider; }
	} // FormProvider

	// ------------------------------------------------------------------------
	protected override void OnLoad( EventArgs e )
	{
		if ( !IsPostBack )
		{
			VirtualUserFormFileProvider formProvider = FormProvider;
			if ( formProvider != null )
			{
				List<string> userFormNames = formProvider.GetAvailableUserForms();
				if ( userFormNames != null && userFormNames.Count > 0 )
				{
					FormListBox.DataSource = userFormNames;
					FormListBox.DataBind();
					FormListBox.SelectedIndex = 0;
					WorkingFormName = userFormNames[ 0 ];
				}
			}
		}

		SetupForm();

		base.OnLoad( e );
	} // OnLoad

	// ------------------------------------------------------------------------
	private void SetupForm()
	{
		FormPlaceHolder.Controls.Clear();

		string workingFormName = WorkingFormName;
		if ( string.IsNullOrEmpty( workingFormName ) )
		{
			return;
		}

		// load form control
		VirtualUserFormFileProvider formProvider = FormProvider;
		if ( formProvider != null )
		{
			string virtualFormName = formProvider.GetVirtualFormName( workingFormName );
			UserControl userForm = new UserFormLoader( virtualFormName, "virtForm" ).Load();
			FormPlaceHolder.Controls.Add( userForm );
		}
	} // SetupForm

	// ------------------------------------------------------------------------
	protected void FormListBox_SelectedIndexChanged( object sender, EventArgs e )
	{
		WorkingFormName = FormListBox.SelectedValue;
		SetupForm();
	} // FormListBox_SelectedIndexChanged

} // class VirtualPage
// -- EOF -------------------------------------------------------------------
