﻿// -- FILE ------------------------------------------------------------------
// name       : VariablesUserForm.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;
using System.Web.UI;
using Itenso.WebUserForms.Controls;
using Itenso.WebUserForms.Data.Variable;
using Itenso.WebUserForms.Runtime;

// --------------------------------------------------------------------------
public partial class VariablesPage : Page 
{

	// ------------------------------------------------------------------------
	protected override void OnLoad( EventArgs e )
	{
		// load form control
		UserControl userForm = new UserFormLoader( "~/UserForms/VariablesUserForm.ascx" ).Load();

		// variables
		IVariableSet variableSet = new DemoVariableProvider().GetFormVariables( userForm );
		VariableAdapter.ExpandVariables( variableSet, userForm );

		FormPlaceHolder.Controls.Add( userForm );

		base.OnLoad( e );
	} // OnLoad

} // class VariablesPage
// -- EOF -------------------------------------------------------------------
