﻿<%@ Register Assembly="Itenso.WebUserForms.Controls" Namespace="Itenso.WebUserForms.Controls"
  TagPrefix="cc1" %>
<%@ Control Language="C#" AutoEventWireup="true" %>

<script language="javascript">

  // --- message box ---
  function scriptMessage( message )
  {
    alert( message );
  }

  // --- change value of form field ---
  function setFieldValue( fieldValue )
  {
    var field = document.getElementById( "<%# TextBox1.ClientID %>" );
    if ( field != null )
    {
      field.value = fieldValue;
    }
  }
  
  // --- change value of form field using a hidden variable ---
  function setFieldVariableValue()
  {
    var sourceField = document.getElementById( "<%# HiddenVariable1.ClientID %>" );
    var destField = document.getElementById( "<%# TextBox1.ClientID %>" );
    if ( sourceField != null && destField != null )
    {
      destField.value = sourceField.value;
    }
  }

  // --- copy value from one filed to another ---
  function copyFieldValue()
  {
    var sourceField = document.getElementById( "<%# TextBox2.ClientID %>" );
    var destField = document.getElementById( "<%# TextBox1.ClientID %>" );
    if ( sourceField != null && destField != null )
    {
      destField.value = sourceField.value;
    }
  }

  // --- radio button list option ---
  function updateSelectedOption()
  {
    var optionField = document.getElementById( "<%# OptionList.ClientID %>" );
    var statusField = document.getElementById( "<%# SelectedOptionLabel.ClientID %>" );
    if ( optionField != null && statusField != null )
    {
      var option;
      var index = 0;
      do
      {
        option = document.getElementById( optionField.id + "_" + index.toString() );
        if ( option != null && option.checked )
        {
          break;
        }
        index++;
      } while ( option != null );
    }
    
    statusField.innerText = option != null ? " - Selected Option: " + option.value : " - No selection.";
  }

  // --- on form load function ---
  function initFieldValue()
  {
    var field = document.getElementById( "<%# TextBox3.ClientID %>" );
    if ( field != null )
    {
      field.value = Date();
    }
  }

  // --- register form loading function ---
  function addLoadEventHandler( func )
  {
    var previousHandler = window.onload;
    if ( typeof window.onload != "function" )
      window.onload = func;
    else
      window.onload = function()
      {
        previousHandler();
        func();
      };
  }

  // --- add form init function ---
  addLoadEventHandler( initFieldValue );
  addLoadEventHandler( updateSelectedOption );
</script>

<table width="100%">
  <tr>
    <td width="20%">
      &nbsp;
    </td>
    <td>
      <button onclick="scriptMessage( 'User Form Script Message.' )">
        Show Message</button>
    </td>
  </tr>
  <tr>
    <td>
      &nbsp;
    </td>
    <td>
      &nbsp;
    </td>
  </tr>
  <tr>
    <td>
      <asp:Label ID="Label1" runat="server" Text="Destination Edit:"></asp:Label>
    </td>
    <td>
      <cc1:TextBox ID="TextBox1" runat="server" FieldName="DestinationField"></cc1:TextBox>
      &nbsp;
      <button onclick="setFieldValue( 'My DefaultValue' )">
        Set Default Value</button>
      &nbsp;
      <button onclick="setFieldVariableValue()">
        Set Variable Value</button>
    </td>
  </tr>
  <tr>
    <td>
      <asp:Label ID="Label2" runat="server" Text="Source Edit:"></asp:Label>
    </td>
    <td>
      <cc1:TextBox ID="TextBox2" runat="server" FieldName="SourceField"></cc1:TextBox>
      &nbsp;
      <button onclick="copyFieldValue()">
        Copy to Destination</button>
    </td>
  </tr>
  <tr>
    <td>
      <asp:Label ID="Label3" runat="server" Text="Loading Date:"></asp:Label>
    </td>
    <td>
      <cc1:TextBox ID="TextBox3" ReadOnly="true" runat="server" FieldName="LoadDate"></cc1:TextBox>
    </td>
  </tr>
  <tr>
    <td>
      <asp:Label ID="Label4" runat="server" Text="Option List Events:"></asp:Label>
    </td>
    <td>
      <table>
        <tr>
          <td>
            <cc1:RadioButtonList ID="OptionList" runat="server" RepeatDirection="Horizontal"
              FieldName="OptionList" FieldValue="Option1" OnClickClientScript="updateSelectedOption()">
              <asp:ListItem Value="Option1">Option 1</asp:ListItem>
              <asp:ListItem Value="Option2">Option 2</asp:ListItem>
              <asp:ListItem Value="Option3">Option 3</asp:ListItem>
            </cc1:RadioButtonList>
          </td>
          <td>
            <asp:Label ID="SelectedOptionLabel" runat="server" Text="-"></asp:Label>
          </td>
        </tr>
      </table>
    </td>
  </tr>
  <tr>
    <td>
      &nbsp;
    </td>
    <td>
      <cc1:HiddenVariable ID="HiddenVariable1" runat="server" FieldName="HiddenValue" FieldValue="Hidden Variable Value" />
    </td>
  </tr>
</table>
<cc1:UserFormHeader ID="UserFormHeader1" runat="server" Description="Client Script Control"
  Type="Test" Name="ClientScriptForm" />
