﻿// -- FILE ------------------------------------------------------------------
// name       : SimpleUserForm.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;
using System.Web.UI;
using Itenso.WebUserForms.Controls;

// --------------------------------------------------------------------------
public partial class SimplePage : Page 
{

	// ------------------------------------------------------------------------
	protected override void OnLoad( EventArgs e )
	{
		// load form control
		this.userForm = new UserFormLoader( "~/UserForms/SimpleUserForm.ascx" ).Load();

		FormPlaceHolder.Controls.Add( this.userForm );

		base.OnLoad( e );
	} // OnLoad

	// ------------------------------------------------------------------------
	private void SetEditMode( bool edit )
	{
		FieldEditEnabler.Enable( this.userForm, edit );
		SubmitButton.Enabled = edit;
		EditButton.Enabled = !edit;
	} // SetEditMode

	// ------------------------------------------------------------------------
	protected void SubmitButton_Click( object sender, EventArgs e )
	{
		SetEditMode( false );
	} // SubmitButton_Click

	// ------------------------------------------------------------------------
	protected void EditButton_Click( object sender, EventArgs e )
	{
		SetEditMode( true );
	} // EditButton_Click

	// ------------------------------------------------------------------------
	// members
	private UserControl userForm;

} // class SimplePage
// -- EOF -------------------------------------------------------------------
