﻿// -- FILE ------------------------------------------------------------------
// name       : SecurityUserForm.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;
using System.Web.UI;
using System.Web.UI.WebControls;
using Itenso.WebUserForms.Controls;

// --------------------------------------------------------------------------
public partial class SecurityPage : Page 
{

	// ------------------------------------------------------------------------
	private string WorkingFormName
	{
		get { return ViewState[ "WorkingForm" ] as string; }
		set { ViewState[ "WorkingForm" ] = value; }
	} // WorkingFormName

	// ------------------------------------------------------------------------
	protected override void OnLoad( EventArgs e )
	{
		if ( !IsPostBack )
		{
			FormListBox.Items.Add( new ListItem( "Embedded Methods", "~/UserForms/EmbeddedMethodUserForm.ascx" ) );
			FormListBox.Items.Add( new ListItem( "Embedded Fields", "~/UserForms/EmbeddedFieldUserForm.ascx" ) );
			FormListBox.SelectedIndex = 0;
			WorkingFormName = FormListBox.Items [ 0 ].Value;
		}

		SetupForm();

		base.OnLoad( e );
	} // OnLoad

	// ------------------------------------------------------------------------
	private void SetupForm()
	{
		FormPlaceHolder.Controls.Clear();
		ErrorMessagePanel.Visible = false;

		string workingFormName = WorkingFormName;
		if ( string.IsNullOrEmpty( workingFormName ) )
		{
			return;
		}

		// load form control
		try
		{
			UserControl userForm = new UserFormLoader( workingFormName ).Load();
			FormPlaceHolder.Controls.Add( userForm );
		}
		catch ( FormSecurityException ex )
		{
			ErrorMessagePanel.Visible = true;
			ErrorMessageLabel.Text = ex.Message + ": " + ex.Info;
		}
		catch ( Exception ex )
		{
			ErrorMessagePanel.Visible = true;
			ErrorMessageLabel.Text = ex.Message;
		}
	} // SetupForm

	// ------------------------------------------------------------------------
	protected void FormListBox_SelectedIndexChanged( object sender, EventArgs e )
	{
		WorkingFormName = FormListBox.SelectedValue;
		SetupForm();
	} // FormListBox_SelectedIndexChanged

} // class SecurityPage
// -- EOF -------------------------------------------------------------------
