﻿// -- FILE ------------------------------------------------------------------
// name       : RuntimeControlsUserForm.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;
using System.Web.UI;
using Itenso.WebUserForms.Controls;
using Itenso.WebUserForms.Runtime;
using Itenso.WebUserForms.RuntimeControls;
using Itenso.WebUserForms.Data.Variable;

// --------------------------------------------------------------------------
public partial class RuntimeControlsPage : Page  
{

	// ------------------------------------------------------------------------
	protected override void OnLoad( EventArgs e )
	{
		// load form control
		UserControl userForm = new UserFormLoader( "~/UserForms/RuntimeControlsUserForm.ascx" ).Load();
		
		// runtime controls
		ControlsAdapter controlsAdapter = new ControlsAdapter( userForm );
		controlsAdapter.Apply();
		
		// lookpus
		LookupAdapter.Apply( DemoLookupProvider.Instance, userForm );

		// variables
		IVariableSet variableSet = new DemoVariableProvider().GetVariables();
		VariableAdapter.ExpandVariables( variableSet, userForm );

		FormPlaceHolder.Controls.Add( userForm );

		base.OnLoad( e );
	} // OnLoad

} // class RuntimeControlsPage
// -- EOF -------------------------------------------------------------------
