﻿// -- FILE ------------------------------------------------------------------
// name       : MasterPage.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;
using Itenso.WebUserForms.Runtime;

// --------------------------------------------------------------------------
public partial class MasterPage : System.Web.UI.MasterPage
{

	// ------------------------------------------------------------------------
	public bool ShowRuntimeHeaderInfo
	{
		get { return this.UserFormInfoControl1.ShowRuntimeHeaderInfo; }
		set { this.UserFormInfoControl1.ShowRuntimeHeaderInfo = value; }
	} // ShowRuntimeHeaderInfo

	// ------------------------------------------------------------------------
	protected override void OnLoad( EventArgs e )
	{
		base.OnLoad( e );

		// header
		DemoMenu demoMenu = new DemoMenu();
		demoMenu.Title = "Web User Forms - Run-Time";
		demoMenu.AddMenuItem( "~/SimpleUserForm.aspx", "Simple Form" );
		demoMenu.AddMenuItem( "~/ValidationUserForm.aspx", "Validation" );
		demoMenu.AddMenuItem( "~/LookupsUserForm.aspx", "Lookups" );
		demoMenu.AddMenuItem( "~/VariablesUserForm.aspx", "Variables" );
		demoMenu.AddMenuItem( "~/ClientScriptUserForm.aspx", "Client Script" );
		demoMenu.AddMenuItem( "~/PersistentUserForm.aspx", "Persistence" );
		demoMenu.AddMenuItem( "~/SecurityUserForm.aspx", "Security" );
		demoMenu.AddMenuItem( "~/VirtualUserForm.aspx", "Virtual Form" );
		demoMenu.AddMenuItem( "~/RuntimeControlsUserForm.aspx", "Run-Time Controls" );
		Header.Controls.Add( demoMenu );

		// footer
		Footer.Controls.Add( new UserFormXmlInfoControl() );
	} // OnLoad

} // class MasterPage
// -- EOF -------------------------------------------------------------------

