﻿// -- FILE ------------------------------------------------------------------
// name       : LookupsUserForm.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;
using System.Web.UI;
using Itenso.WebUserForms.Controls;
using Itenso.WebUserForms.Runtime;

// --------------------------------------------------------------------------
public partial class LookupsPage : Page
{

	// ------------------------------------------------------------------------
	protected override void OnLoad( EventArgs e )
	{
		// load form control
		this.userForm = new UserFormLoader( "~/UserForms/LookupsUserForm.ascx" ).Load();

		// lookup
		LookupAdapter.Apply( DemoLookupProvider.Instance, this.userForm );

		FormPlaceHolder.Controls.Add( this.userForm );

		base.OnLoad( e );
	} // OnLoad

	// ------------------------------------------------------------------------
	private void SetEditMode( bool allowEdit )
	{
		FieldEditEnabler.Enable( this.userForm, allowEdit );
		SubmitButton.Enabled = allowEdit;
		EditButton.Enabled = !allowEdit;
	} // SetEditMode

	// ------------------------------------------------------------------------
	protected void SubmitButton_Click( object sender, EventArgs e )
	{
		SetEditMode( false );
	} // SubmitButton_Click

	// ------------------------------------------------------------------------
	protected void EditButton_Click( object sender, EventArgs e )
	{
		SetEditMode( true );
	} // EditButton_Click

	// ------------------------------------------------------------------------
	protected void ClearLookups_Click( object sender, EventArgs e )
	{
		DemoLookupProvider.Instance.Clear();
	} // ClearLookups_Click

	// ------------------------------------------------------------------------
	// members
	private UserControl userForm;

} // class LookupsPage
// -- EOF -------------------------------------------------------------------
