﻿// -- FILE ------------------------------------------------------------------
// name       : DemoVariableProvider.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;
using System.Globalization;
using System.Web.UI;
using Itenso.WebUserForms.Data.Form;
using Itenso.WebUserForms.Data.Variable;
using Itenso.WebUserForms.Runtime;

// --------------------------------------------------------------------------
public class DemoVariableProvider : IVariableProvider
{

	// ------------------------------------------------------------------------
	public DemoVariableProvider()
	{
	} // DemoVariableProvider

	// ------------------------------------------------------------------------
	public IVariableSet GetVariables()
	{
		return GetVariables( null );
	} // GetVariables

	// ------------------------------------------------------------------------
	public IVariableSet GetVariables( string formType )
	{
		VariableSet variableSet = new VariableSet();

		variableSet.MapContentToVariable( "System.CurrentDate", DateTime.Now.ToString( CultureInfo.InvariantCulture ) );
		variableSet.MapContentToVariable( "System.User", "John Doe" );

		return variableSet;
	} // GetVariables

	// ------------------------------------------------------------------------
	public IVariableSet GetFormVariables( UserControl userControl )
	{
		IVariableSet variableSet = GetVariables();

		if ( userControl != null )
		{
			IForm form = UserFormAdapter.ExtractForm( userControl );
			if ( form != null )
			{
				variableSet.MapContentToVariable( "CurrentForm.Name", form.Name );
				variableSet.MapContentToVariable( "CurrentForm.Type", form.FormType );
			}
		}

		return variableSet;
	} // GetFormVariables

} // class DemoVariableProvider
// -- EOF -------------------------------------------------------------------
