﻿// -- FILE ------------------------------------------------------------------
// name       : DemoMenu.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;
using System.Drawing;
using System.Collections;
using System.Collections.Specialized;
using System.ComponentModel;
using System.Web.UI.WebControls;

// ------------------------------------------------------------------------
[Browsable( false )]
public class DemoMenu : CompositeControl
{

	// ----------------------------------------------------------------------
	public DemoMenu()
	{
	} // DemoMenu

	// ----------------------------------------------------------------------
	[Browsable( false )]
	public string Title
	{
		get { return this.title; }
		set { this.title = value; }
	} // Title

	// ----------------------------------------------------------------------
	[Browsable( false )]
	public Unit TitleHeight
	{
		get { return this.titleHeight; }
		set { this.titleHeight = value; }
	} // TitleHeight

	// ----------------------------------------------------------------------
	[Browsable( false )]
	public bool ShowTitle
	{
		get { return this.showTitle; }
		set { this.showTitle = value; }
	} // ShowTitle

	// ----------------------------------------------------------------------
	[Browsable( false )]
	public bool ShowPageName
	{
		get { return this.showPageName; }
		set { this.showPageName = value; }
	} // ShowPageName

	// ----------------------------------------------------------------------
	[Browsable( false )]
	public bool ShowSpacer
	{
		get { return this.showSpacer; }
		set { this.showSpacer = value; }
	} // ShowSpacer

	// ----------------------------------------------------------------------
	[Browsable( false )]
	public Unit MenuHeight
	{
		get { return this.menuHeight; }
		set { this.menuHeight = value; }
	} // MenuHeight

	// ----------------------------------------------------------------------
	[Browsable( false )]
	public Unit SpacerHeight
	{
		get { return this.spacerHeight; }
		set { this.spacerHeight = value; }
	} // SpacerHeight

	// ------------------------------------------------------------------------
	public void AddMenuItem( string text, string url )
	{
		if ( string.IsNullOrEmpty( text ) )
		{
			throw new ArgumentNullException( "text" );
		}
		if ( string.IsNullOrEmpty( url ) )
		{
			throw new ArgumentNullException( "url" );
		}

		this.menuItems.Add( url, text );
	} // AddMenuItem

	// ------------------------------------------------------------------------
	protected override void CreateChildControls()
	{
		base.CreateChildControls();
		SetupControl();
	} // CreateChildControls

	// ------------------------------------------------------------------------
	private void SetupControl()
	{
		Table layoutTable = new Table();
		layoutTable.Width = Unit.Percentage( 100 );

		// application title
		if ( this.showTitle && !string.IsNullOrEmpty( this.title ) )
		{
			TableRow applicationTitleRow = new TableRow();
			applicationTitleRow.Height = this.titleHeight;

			TableCell applicationTitleCell = new TableCell();
			applicationTitleCell.ColumnSpan = this.menuItems.Count;
			applicationTitleCell.HorizontalAlign = HorizontalAlign.Center;
			applicationTitleCell.BackColor = SystemColors.Info;

			Label appTitleLabel = new Label();
			appTitleLabel.Font.Bold = true;
			appTitleLabel.Font.Size = FontUnit.Larger;
			appTitleLabel.Text = this.title;
			applicationTitleCell.Controls.Add( appTitleLabel );

			applicationTitleRow.Cells.Add( applicationTitleCell );
			layoutTable.Rows.Add( applicationTitleRow );
		}

		// menu
		string curPageFilePath = Page.Request.AppRelativeCurrentExecutionFilePath;
		if ( this.menuItems.Count > 0 )
		{
			TableRow menuRow = new TableRow();
			menuRow.Height = this.menuHeight;

			IDictionaryEnumerator enumerator = this.menuItems.GetEnumerator();
			while ( enumerator.MoveNext() )
			{
				TableCell menuItemCell = new TableCell();
				menuItemCell.HorizontalAlign = HorizontalAlign.Center;
				menuItemCell.BackColor = SystemColors.Control;

				HyperLink menuHyperLink = new HyperLink();
				menuHyperLink.Text = enumerator.Key as string;
				menuHyperLink.NavigateUrl = enumerator.Value as string;
				if ( !string.IsNullOrEmpty( curPageFilePath ) && curPageFilePath.Equals( menuHyperLink.NavigateUrl ) )
				{
					menuHyperLink.Enabled = false;
				}
				menuItemCell.Controls.Add( menuHyperLink );
				menuRow.Cells.Add( menuItemCell );
			}
			layoutTable.Rows.Add( menuRow );
		}

		// page name
		if ( this.showPageName )
		{
			TableRow pageNameRow = new TableRow();
			pageNameRow.Height = this.titleHeight;

			TableCell pageNameCell = new TableCell();
			pageNameCell.ColumnSpan = this.menuItems.Count;
			pageNameCell.HorizontalAlign = HorizontalAlign.Center;
			pageNameCell.BackColor = SystemColors.Info;

			Label pageNameLabel = new Label();
			pageNameLabel.Font.Size = FontUnit.Larger;
			pageNameLabel.Text = Page.Title;
			pageNameCell.Controls.Add( pageNameLabel );

			pageNameRow.Cells.Add( pageNameCell );
			layoutTable.Rows.Add( pageNameRow );
		}

		// spacer
		if ( this.showSpacer )
		{
			TableRow spacerRow = new TableRow();
			spacerRow.Height = this.spacerHeight;
			layoutTable.Rows.Add( spacerRow );
		}

		if ( layoutTable.Rows.Count > 0 )
		{
			Controls.Add( layoutTable );
		}
	} // SetupControl

	// ------------------------------------------------------------------------
	// members
	private readonly OrderedDictionary menuItems = new OrderedDictionary();
	private string title;
	private bool showTitle = true;
	private bool showPageName = true;
	private bool showSpacer = true;

	private Unit titleHeight = Unit.Pixel( 25 );
	private Unit menuHeight = Unit.Pixel( 25 );
	private Unit spacerHeight = Unit.Pixel( 5 );

} // class DemoMenu
// -- EOF -------------------------------------------------------------------
