﻿// -- FILE ------------------------------------------------------------------
// name       : DemoLookupProvider.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using Itenso.WebUserForms.Data.Lookup;

// --------------------------------------------------------------------------
public sealed class DemoLookupProvider : LookupRepository
{

	// ------------------------------------------------------------------------
	private DemoLookupProvider()
	{
	} // DemoLookupProvider

	// ------------------------------------------------------------------------
	public static DemoLookupProvider Instance
	{
		get
		{
			if ( instance == null )
			{
				lock ( mutex )
				{
					if ( instance == null )
					{
						instance = new DemoLookupProvider();
					}
				}
			}
			return instance;
		}
	} // Instance

	// ------------------------------------------------------------------------
	protected override ILookupValueCollection OnLookupRequest( string lookupName, string formType )
	{
		ILookupValueCollection lookup = null;

		switch ( lookupName )
		{
			case "MaritialStatus":
				lookup = new LookupValueCollection( lookupName );
				lookup.Add( new LookupValue( "Single" ) );
				lookup.Add( new LookupValue( "Married" ) );
				lookup.Add( new LookupValue( "Separated" ) );
				lookup.Add( new LookupValue( "Divorced" ) );
				lookup.Add( new LookupValue( "Widowed" ) );
				lookup.Add( new LookupValue( "Engaged" ) );
				lookup.Add( new LookupValue( "Annulled" ) );
				lookup.Add( new LookupValue( "Cohabitating" ) );
				lookup.Add( new LookupValue( "Deceased" ) );
				break;
		}

		return lookup;
	} // OnLookupRequest

	// ----------------------------------------------------------------------
	// members
	private static readonly object mutex = new object();
	private volatile static DemoLookupProvider instance;

} // class DemoLookupProvider
// -- EOF -------------------------------------------------------------------
