﻿// -- FILE ------------------------------------------------------------------
// name       : TimePicker.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;
using Itenso.WebUserForms.Controls;

namespace Itenso.WebUserForms.RuntimeControls
{

#if TP_DATE_FIELDS

	// ------------------------------------------------------------------------
	public class TimePicker : System.Web.UI.WebControls.TextBox, IUserFormField
	{

		// ----------------------------------------------------------------------
		public TimePicker( Controls.TimePicker timePicker )
		{
			if ( timePicker == null )
			{
				throw new ArgumentNullException( "timePicker" );
			}

			// form values
			if ( !string.IsNullOrEmpty( timePicker.FieldName ) )
			{
				this.FieldName = timePicker.FieldName;
			}
			if ( !string.IsNullOrEmpty( timePicker.FieldValue ) )
			{
				this.FieldValue = timePicker.FieldValue;
			}

			// control values
			base.ID = timePicker.ID;
			base.Width = timePicker.Width;
			base.CssClass = timePicker.CssClass;
		} // TimePicker

		// ----------------------------------------------------------------------
		public string FieldName
		{
			get { return this.fieldName; }
			set { this.fieldName = value; }
		} // FieldName

		// ----------------------------------------------------------------------
		public string FieldValue
		{
			get { return Text; }
			set { Text = value; }
		} // FieldValue

		// ----------------------------------------------------------------------
		bool IUserFormField.AllowEdit
		{
			get { return !ReadOnly; }
			set { ReadOnly = !value; }
		} // AllowEdit

		// ----------------------------------------------------------------------
		public override string ToString()
		{
			return FormFieldTool.GetFieldDescription( this );
		} // ToString

		// ----------------------------------------------------------------------
		// members
		private string fieldName;

	} // class TimePicker

#endif // TP_DATE_FIELDS

} // namespace Itenso.WebUserForms.RuntimeControls
// -- EOF -------------------------------------------------------------------
