﻿// -- FILE ------------------------------------------------------------------
// name       : LookupComboBox.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using Itenso.WebUserForms.Controls;

namespace Itenso.WebUserForms.RuntimeControls
{

#if (LOOKUP_FIELDS && TP_COMBO_FIELDS)

	// ------------------------------------------------------------------------
	public class LookupComboBox : ComboBox, ILookupField
	{

		// ----------------------------------------------------------------------
		public LookupComboBox( Controls.LookupComboBox lookupComboBox ) :
			base( lookupComboBox )
		{
			this.lookupName = lookupComboBox.LookupName;
		} // LookupComboBox

		// ----------------------------------------------------------------------
		public string LookupName
		{
			get { return this.lookupName; }
			set { this.lookupName = value; }
		} // LookupName

		// ----------------------------------------------------------------------
		// members
		private string lookupName;

	} // class LookupComboBox

#endif // LOOKUP_FIELDS && TP_COMBO_FIELDS

} // namespace Itenso.WebUserForms.RuntimeControls
// -- EOF -------------------------------------------------------------------
