﻿// -- FILE ------------------------------------------------------------------
// name       : DatePicker.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;
using Itenso.WebUserForms.Controls;

namespace Itenso.WebUserForms.RuntimeControls
{

#if TP_DATE_FIELDS

	// ------------------------------------------------------------------------
	public class DatePicker : System.Web.UI.WebControls.TextBox, IUserFormField
	{

		// ----------------------------------------------------------------------
		public DatePicker( Controls.DatePicker datePicker )
		{
			if ( datePicker == null )
			{
				throw new ArgumentNullException( "datePicker" );
			}

			// form values
			if ( !string.IsNullOrEmpty( datePicker.FieldName ) )
			{
				this.FieldName = datePicker.FieldName;
			}
			if ( !string.IsNullOrEmpty( datePicker.FieldValue ) )
			{
				this.FieldValue = datePicker.FieldValue;
			}

			// control values
			base.ID = datePicker.ID;
			base.Width = datePicker.Width;
			base.CssClass = datePicker.CssClass;
		} // DatePicker

		// ----------------------------------------------------------------------
		public string FieldName
		{
			get { return this.fieldName; }
			set { this.fieldName = value; }
		} // FieldName

		// ----------------------------------------------------------------------
		public string FieldValue
		{
			get { return Text; }
			set { Text = value; }
		} // FieldValue

		// ----------------------------------------------------------------------
		bool IUserFormField.AllowEdit
		{
			get { return !ReadOnly; }
			set { ReadOnly = !value; }
		} // AllowEdit

		// ----------------------------------------------------------------------
		public override string ToString()
		{
			return FormFieldTool.GetFieldDescription( this );
		} // ToString

		// ----------------------------------------------------------------------
		// members
		private string fieldName;

	} // class DatePicker

#endif // TP_DATE_FIELDS

} // namespace Itenso.WebUserForms.RuntimeControls
// -- EOF -------------------------------------------------------------------
