﻿// -- FILE ------------------------------------------------------------------
// name       : ControlsAdapter.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System.Web.UI;
using Itenso.WebUserForms.Runtime;

namespace Itenso.WebUserForms.RuntimeControls
{

	// ------------------------------------------------------------------------
	public class ControlsAdapter : RuntimeControlsAdapter
	{

		// ----------------------------------------------------------------------
		public ControlsAdapter( Control startControl )
			: base( startControl )
		{
		} // ControlsAdapter

		// ----------------------------------------------------------------------
		protected override Control GetRuntimeControl( Control placeholderControl )
		{
#if (LOOKUP_FIELDS && TP_COMBO_FIELDS)
			Controls.LookupComboBox lookupComboBox = placeholderControl as Controls.LookupComboBox;
			if ( lookupComboBox != null )
			{
				return new LookupComboBox( lookupComboBox );
			}
#endif // LOOKUP_FIELDS && TP_COMBO_FIELDS

#if TP_COMBO_FIELDS
			Controls.ComboBox comboBox = placeholderControl as Controls.ComboBox;
			if ( comboBox != null )
			{
				return new ComboBox( comboBox );
			}
#endif // TP_COMBO_FIELDS

#if TP_DATE_FIELDS
			Controls.DatePicker datePicker = placeholderControl as Controls.DatePicker;
			if ( datePicker != null )
			{
				return new DatePicker( datePicker );
			}
#endif // TP_DATE_FIELDS

#if TP_DATE_FIELDS
			Controls.TimePicker timePicker = placeholderControl as Controls.TimePicker;
			if ( timePicker != null )
			{
				return new TimePicker( timePicker );
			}
#endif // TP_DATE_FIELDS

			return null;
		} // GetRuntimeControl

	} // class ControlsAdapter

} // namespace Itenso.WebUserForms.RuntimeControls
// -- EOF -------------------------------------------------------------------
