﻿// -- FILE ------------------------------------------------------------------
// name       : ComboBox.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;
using System.Web.UI.WebControls;
using Itenso.WebUserForms.Controls;

namespace Itenso.WebUserForms.RuntimeControls
{

#if TP_COMBO_FIELDS

	// ------------------------------------------------------------------------
	public class ComboBox : System.Web.UI.WebControls.DropDownList, IListField
	{

		// ----------------------------------------------------------------------
		public ComboBox( Controls.ComboBox comboBox )
		{
			if ( comboBox == null )
			{
				throw new ArgumentNullException( "comboBox" );
			}

			// form values
			if ( !string.IsNullOrEmpty( comboBox.FieldName ) )
			{
				this.FieldName = comboBox.FieldName;
			}
			if ( !string.IsNullOrEmpty( comboBox.FieldValue ) )
			{
				this.FieldValue = comboBox.FieldValue;
			}

			// control values
			base.ID = comboBox.ID;
			base.Width = comboBox.Width;
			base.CssClass = comboBox.CssClass;
			foreach ( ListItem listItem in comboBox.Items )
			{
				base.Items.Add( new ListItem( listItem.Text, listItem.Value ) );
			}
			base.SelectedIndex = comboBox.SelectedIndex;
			base.Text = comboBox.Text;
		} // ComboBox

		// ----------------------------------------------------------------------
		public string FieldName
		{
			get { return this.fieldName; }
			set { this.fieldName = value; }
		} // FieldName

		// ----------------------------------------------------------------------
		public string FieldValue
		{
			get { return SelectedValue; }
			set
			{
				ListItem listItem = Items.FindByValue( value );
				if ( listItem != null )
				{
					SelectedIndex = Items.IndexOf( listItem );
				}
			}
		} // FieldValue

		// ----------------------------------------------------------------------
		bool IUserFormField.AllowEdit
		{
			get { return base.Enabled; }
			set { base.Enabled= value; }
		} // AllowEdit

		// ----------------------------------------------------------------------
		public override string ToString()
		{
			return FormFieldTool.GetFieldDescription( this );
		} // ToString

		// ----------------------------------------------------------------------
		// members
		private string fieldName;

	} // class ComboBox

#endif // TP_COMBO_FIELDS

} // namespace Itenso.WebUserForms.RuntimeControls
// -- EOF -------------------------------------------------------------------
