﻿// -- FILE ------------------------------------------------------------------
// name       : VirtualUserFormProvider.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;
using System.IO;
using System.Web;
using System.Web.Hosting;
using System.Web.Caching;
using System.Collections;

namespace Itenso.WebUserForms.Runtime
{

	// ------------------------------------------------------------------------
	public abstract class VirtualUserFormProvider : VirtualPathProvider
	{

		// ----------------------------------------------------------------------
		protected VirtualUserFormProvider( string virtualPath )
		{
			if ( string.IsNullOrEmpty( virtualPath ) )
			{
				throw new ArgumentNullException( "virtualPath" );
			}

			this.virtualPath = virtualPath;
		} // VirtualUserFormProvider

		// ----------------------------------------------------------------------
		public string VirtualPath
		{
			get { return this.virtualPath; }
		} // VirtualPath

		// ----------------------------------------------------------------------
		private bool IsUserControlRequest( string requestPath )
		{
			string relativePath = VirtualPathUtility.ToAppRelative( requestPath );
			return relativePath.StartsWith( this.virtualPath, StringComparison.InvariantCultureIgnoreCase );
		} // IsUserControlRequest

		// ----------------------------------------------------------------------
		public override bool FileExists( string requestPath )
		{
			return IsUserControlRequest( requestPath ) || base.FileExists( requestPath );
		} // FileExists

		// ----------------------------------------------------------------------
		public override VirtualFile GetFile( string requestPath )
		{
			if ( IsUserControlRequest( requestPath ) )
			{
				Stream stream = LoadUserForm( requestPath );
				if ( stream != null )
				{
					return new VirtualUserFormFile( requestPath, stream );
				}
			}

			return base.GetFile( requestPath );
		} // GetFile

		// ----------------------------------------------------------------------
		public override CacheDependency GetCacheDependency( string requestPath, IEnumerable requestPathDependencies, DateTime utcStart )
		{
			if ( IsUserControlRequest( requestPath ) )
			{
				return null;
			}

			return base.GetCacheDependency( requestPath, requestPathDependencies, utcStart );
		} // GetCacheDependency

		// ----------------------------------------------------------------------
		protected abstract Stream LoadUserForm( string requestPath );

		// ----------------------------------------------------------------------
		// members
		private readonly string virtualPath;

	} // class VirtualUserFormProvider

} // namespace Itenso.WebUserForms.Runtime
// -- EOF -------------------------------------------------------------------
