﻿// -- FILE ------------------------------------------------------------------
// name       : VirtualUserFormFileProvider.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;
using System.IO;
using System.Text;
using System.Collections.Generic;
using Itenso.WebUserForms.Controls;

namespace Itenso.WebUserForms.Runtime
{

	// ------------------------------------------------------------------------
	public class VirtualUserFormFileProvider : VirtualUserFormProvider, IUserFormProvider
	{

		// ----------------------------------------------------------------------
		public VirtualUserFormFileProvider( string virtualPath, string physicalPath )
			: base( virtualPath )
		{
			if ( string.IsNullOrEmpty( physicalPath ) )
			{
				throw new ArgumentNullException( "physicalPath" );
			}
			if ( !Directory.Exists( physicalPath ) )
			{
				throw new ArgumentException( "invalid physical path" );
			}

			this.physicalPath = physicalPath;
		} // VirtualUserFormFileProvider

		// ----------------------------------------------------------------------
		public string PhysicalPath
		{
			get { return this.physicalPath; }
		} // PhysicalPath

		// ----------------------------------------------------------------------
		public string GetVirtualFormName( string formName )
		{
			if ( string.IsNullOrEmpty( formName ) )
			{
				throw new ArgumentNullException( "formName" );
			}

			string virtualFormName = VirtualPath;
			if ( !virtualFormName.EndsWith( "/" ) )
			{
				virtualFormName += "/";
			}
			virtualFormName += formName;
			if ( !virtualFormName.EndsWith( UserFormInfo.FileExtension ) )
			{
				virtualFormName += UserFormInfo.FileExtension;
			}

			return virtualFormName;
		} // GetVirtualFormName

		// ----------------------------------------------------------------------
		public List<string> GetAvailableUserForms()
		{
			return ( (IUserFormProvider)this ).GetAvailableUserForms( null );
		} // GetAvailableUserForms

		// ----------------------------------------------------------------------
		List<string> IUserFormProvider.GetAvailableUserForms( string formType )
		{
			List<string> formInfos = new List<string>();

			DirectoryInfo directoryInfo = new DirectoryInfo( this.physicalPath );
			foreach ( FileInfo fileInfo in directoryInfo.GetFiles( "*" + UserFormInfo.FileExtension ) )
			{
				formInfos.Add( fileInfo.Name.Replace( fileInfo.Extension, string.Empty ) );
			}

			return formInfos;
		} // IUserFormProvider.GetAvailableUserForms

		// ----------------------------------------------------------------------
		protected override Stream LoadUserForm( string virtualPath )
		{
			MemoryStream stream = null;

			string baseVirtualPath = VirtualPath.TrimStart( '~' );
			int pathIndex = virtualPath.IndexOf( baseVirtualPath, StringComparison.Ordinal );
			if ( pathIndex >= 0 )
			{
				string physicalFileName = Path.Combine(
					PhysicalPath,
					virtualPath.Substring( pathIndex + baseVirtualPath.Length + 1 ) );
				using ( StreamReader streamReader = new StreamReader( physicalFileName ) )
				{
					stream = new MemoryStream( Encoding.Default.GetBytes( streamReader.ReadToEnd() ) );
				}
			}

			return stream;
		} // LoadUserForm

		// ----------------------------------------------------------------------
		// members
		private readonly string physicalPath;

	} // class VirtualUserFormFileProvider

} // namespace Itenso.WebUserForms.Runtime
// -- EOF -------------------------------------------------------------------
