﻿// -- FILE ------------------------------------------------------------------
// name       : VirtualUserFormFile.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;
using System.IO;
using System.Web.Hosting;

namespace Itenso.WebUserForms.Runtime
{

	// ------------------------------------------------------------------------
	internal class VirtualUserFormFile : VirtualFile
	{

		// ----------------------------------------------------------------------
		public VirtualUserFormFile( string virtualPath, Stream stream )
			: base( virtualPath )
		{
			if ( stream == null )
			{
				throw new ArgumentNullException( "stream" );
			}

			this.stream = stream;
		} // VirtualUserFormFile

		// ----------------------------------------------------------------------
		public Stream Stream
		{
			get { return this.stream; }
		} // Stream

		// ----------------------------------------------------------------------
		public override Stream Open()
		{
			return this.stream;
		} // Open

		// ----------------------------------------------------------------------
		// members
		private readonly Stream stream;

	} // class VirtualUserFormFile

} // namespace Itenso.WebUserForms.Runtime
// -- EOF -------------------------------------------------------------------
