﻿// -- FILE ------------------------------------------------------------------
// name       : VariableAdapter.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;
using System.Web.UI;
using Itenso.WebUserForms.Controls;
using Itenso.WebUserForms.Data.Variable;

namespace Itenso.WebUserForms.Runtime
{

	// ------------------------------------------------------------------------
	public static class VariableAdapter
	{

		// ----------------------------------------------------------------------
		public static void ExpandVariables( IVariableProvider variableProvider, UserControl userControl )
		{
			if ( variableProvider == null )
			{
				throw new ArgumentNullException( "variableProvider" );
			}
			if ( userControl == null )
			{
				throw new ArgumentNullException( "userControl" );
			}

			IVariableSet variableSet = variableProvider.GetVariables( null );
			if ( variableSet == null )
			{
				return;
			}

			ExpandVariables( variableSet, userControl );
		} // ExpandVariables

		// ----------------------------------------------------------------------
		public static void ExpandVariables( IVariableSet variableSet, UserControl userControl )
		{
			if ( variableSet == null )
			{
				throw new ArgumentNullException( "variableSet" );
			}
			if ( userControl == null )
			{
				throw new ArgumentNullException( "userControl" );
			}

			if ( variableSet.Count == 0 )
			{
				return; // nothing to do
			}

			ExpressionFieldCollector expressionFieldCollector = new ExpressionFieldCollector( userControl );
			expressionFieldCollector.Collect();
			foreach ( IExpressionField expressionField in expressionFieldCollector.ExpressionFields )
			{
				string fieldExpression = expressionField.FieldExpression;
				if ( string.IsNullOrEmpty( fieldExpression ) )
				{
					continue;
				}

				string expandedFieldExpression = variableSet.Expand( fieldExpression );
				expressionField.FieldValue = expandedFieldExpression;
			}
		} // ExpandVariables

	} // class VariableAdapter

} // namespace Itenso.WebUserForms.Runtime
// -- EOF -------------------------------------------------------------------
