﻿// -- FILE ------------------------------------------------------------------
// name       : UserFormXmlInfoRenderer.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;
using System.Drawing;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Itenso.WebUserForms.Controls;
using Itenso.WebUserForms.Data.Form;

namespace Itenso.WebUserForms.Runtime
{

	// ------------------------------------------------------------------------
	internal class UserFormXmlInfoRenderer : UserFormVisitor
	{

		// ----------------------------------------------------------------------
		public UserFormXmlInfoRenderer( Control startControl )
			: base( startControl )
		{
		} // UserFormXmlInfoRenderer

		// ----------------------------------------------------------------------
		public void Render( Control parentControl )
		{
			if ( parentControl == null )
			{
				throw new ArgumentNullException( "parentControl" );
			}

			this.parent = parentControl;
			Start();
		} // Render

		// ----------------------------------------------------------------------
		protected override void EnterForm( Control control )
		{
			Table layoutTable = new Table();
			layoutTable.Width = Unit.Percentage( 100 );

			string formXmlText = string.Empty;
			IForm form = UserFormAdapter.ExtractForm( control as UserControl );
			if ( form != null )
			{
				formXmlText = FormXml.Instance.ToXmlString( form );
			}
			formXmlText = HttpUtility.HtmlEncode( formXmlText );
			formXmlText = formXmlText.Replace( "\n", "<br />" );
			formXmlText = formXmlText.Replace( "  ", "&nbsp;&nbsp;&nbsp;&nbsp;" );

			TableRow tableRow = new TableRow();
			TableCell tableCell = new TableCell();
			tableCell.BackColor = SystemColors.Info;

			Literal literal = new Literal();
			literal.Text = formXmlText;
			tableCell.Controls.Add( literal );

			tableRow.Cells.Add( tableCell );
			layoutTable.Rows.Add( tableRow );

			this.parent.Controls.Add( layoutTable );
		} // EnterForm

		// ----------------------------------------------------------------------
		// members
		private Control parent;

	} // class UserFormXmlInfoRenderer

} // namespace Itenso.WebUserForms.Runtime
// -- EOF -------------------------------------------------------------------
