// -- FILE ------------------------------------------------------------------
// name       : UserFormAdapterException.cs
// project    : Itenso Web User Forms
// created    : Jani Giannoudis - 2008.10.30
// language   : c#
// environment: .NET 2.0
// copyright  : (c) 2008-2012 by Itenso GmbH, Switzerland
// --------------------------------------------------------------------------
using System;
using Itenso.WebUserForms.Data.Form;
using Itenso.WebUserForms.Controls;

namespace Itenso.WebUserForms.Runtime
{

	// ------------------------------------------------------------------------
	public class UserFormAdapterException : Exception
	{

		// ----------------------------------------------------------------------
		public UserFormAdapterException()
		{
		} // UserFormAdapterException

		// ----------------------------------------------------------------------
		public UserFormAdapterException( string message, IUserForm userForm, IForm formData ) :
			base( message )
		{
			this.userForm = userForm;
			this.formData = formData;
		} // UserFormAdapterException

		// ----------------------------------------------------------------------
		public IUserForm UserForm
		{
			get { return this.userForm; }
		} // UserForm

		// ----------------------------------------------------------------------
		public IForm FormData
		{
			get { return this.formData; }
		} // FormData

		// ----------------------------------------------------------------------
		// members
		private readonly IUserForm userForm;
		private readonly IForm formData;

	} // class UserFormAdapterException

} // namespace Itenso.WebUserForms.Runtime
// -- EOF -------------------------------------------------------------------
